/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.arms.logger;

import com.navercorp.pinpoint.common.arms.logger.ArmsLogger;
import com.navercorp.pinpoint.common.arms.logger.FastDateFormat;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import sun.misc.Unsafe;

final class ArmsLoggerUtils {
    private static final ThreadLocal<FastDateFormat> dateFmt;
    private static final Unsafe UNSAFE;
    public static final String NEWLINE = "\r\n";
    private static final int PID;

    ArmsLoggerUtils() {
    }

    public static String getSystemProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static long getSystemPropertyForLong(String key, long defaultValue) {
        try {
            return Long.parseLong(System.getProperty(key));
        }
        catch (Throwable var4) {
            return defaultValue;
        }
    }

    public static String getProperties(String key) {
        try {
            return ArmsLogger.properties.getProperty(key);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static String getProperties(String key, String defaultStr) {
        try {
            String ret = ArmsLogger.properties.getProperty(key);
            if (ret == null) {
                return defaultStr;
            }
            return ArmsLogger.properties.getProperty(key);
        }
        catch (Throwable throwable) {
            return defaultStr;
        }
    }

    public static long getPropertiesForLong(String key, long defaultValue) {
        try {
            return Long.parseLong(ArmsLogger.properties.getProperty(key));
        }
        catch (Throwable throwable) {
            return defaultValue;
        }
    }

    public static int getPropertiesForInteger(String key, int defaultValue) {
        try {
            return Integer.parseInt(ArmsLogger.properties.getProperty(key));
        }
        catch (Throwable throwable) {
            return defaultValue;
        }
    }

    public static <T> T checkNotNull(T value, String name) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException(name + " is null");
        }
        return value;
    }

    public static boolean isNotBlank(String str) {
        return !ArmsLoggerUtils.isBlank(str);
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str != null && (strLen = str.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(str.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static final String getClassLocation(Class<?> clazz) {
        try {
            URL resource = clazz.getProtectionDomain().getCodeSource().getLocation();
            if (resource != null) {
                return resource.toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "--<unknown location>--";
    }

    private static Unsafe doGetUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (Throwable var2) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Class<Unsafe> k = Unsafe.class;
                        for (Field f : k.getDeclaredFields()) {
                            f.setAccessible(true);
                            Object x = f.get(null);
                            if (!k.isInstance(x)) continue;
                            return (Unsafe)k.cast(x);
                        }
                        throw new NoSuchFieldError("the Unsafe");
                    }
                });
            }
            catch (Throwable var1) {
                return null;
            }
        }
    }

    public static int getCurrrentPid() {
        return PID;
    }

    private static int doGetCurrrentPid() {
        String pidStr = ArmsLoggerUtils.getSystemProperty("ARMS.LOCAL.PID");
        if (ArmsLoggerUtils.isNotBlank(pidStr) && ArmsLoggerUtils.isNumeric(pidStr)) {
            try {
                long pidLong = Long.parseLong(pidStr);
                return Math.abs((int)pidLong);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        try {
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            String name = runtime.getName();
            return Integer.parseInt(name.substring(0, name.indexOf(64)));
        }
        catch (Throwable t) {
            return 0;
        }
    }

    public static final boolean isNumeric(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isNumeric(String str) {
        if (ArmsLoggerUtils.isBlank(str)) {
            return false;
        }
        int sz = str.length();
        for (int i = 0; i < sz; ++i) {
            if (ArmsLoggerUtils.isNumeric(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String formatTime(long timestamp) {
        return dateFmt.get().format(timestamp);
    }

    public static Unsafe getUnsafe() {
        return UNSAFE;
    }

    static {
        PID = ArmsLoggerUtils.doGetCurrrentPid();
        dateFmt = new ThreadLocal<FastDateFormat>(){

            @Override
            protected FastDateFormat initialValue() {
                return new FastDateFormat();
            }
        };
        UNSAFE = ArmsLoggerUtils.doGetUnsafe();
    }
}

