/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.arms.logger;

import com.navercorp.pinpoint.common.arms.logger.Appender;
import com.navercorp.pinpoint.common.arms.logger.ArmsAPMLogger;
import com.navercorp.pinpoint.common.arms.logger.ArmsLoggerUtils;
import com.navercorp.pinpoint.common.arms.logger.RollingFileAppender;
import com.navercorp.pinpoint.common.arms.logger.SyncAppender;
import com.navercorp.pinpoint.common.arms.logger.TokenBucket;
import com.navercorp.pinpoint.common.arms.logger.UserLogBeanKey;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class ArmsLoggerDispatch {
    private static ArmsLoggerDispatch instance = new ArmsLoggerDispatch();
    public static final String USER_HOME = ArmsLoggerDispatch.locateUserHome();
    public static final String BASE_LOG_DIR = ArmsLoggerDispatch.locateBaseLogPath();
    public static final String LOG_PATH = ArmsLoggerDispatch.locateARMSLogPath();
    public static final Charset DEFAULT_CHARSET = ArmsLoggerDispatch.getDefaultOutputCharset();
    public static final String ARMSLOGGER_SELF_LOG_FILE = ArmsLoggerDispatch.locateARMSSelfLogPath();
    public static Appender selfAppender = ArmsLoggerDispatch.createSelfLogger();
    private static TokenBucket exceptionBucket = new TokenBucket(10L, TimeUnit.SECONDS.toMillis(10L));
    public static Map<UserLogBeanKey, ArmsAPMLogger> armsLoggerMap = new ConcurrentHashMap<UserLogBeanKey, ArmsAPMLogger>();

    private ArmsLoggerDispatch() {
    }

    public static ArmsLoggerDispatch getInstance() {
        return instance;
    }

    public static ArmsAPMLogger getArmsLogger(String userId, String logType) {
        UserLogBeanKey userLogBeanKey = new UserLogBeanKey(userId, logType);
        if (armsLoggerMap.containsKey(userLogBeanKey)) {
            return armsLoggerMap.get(userLogBeanKey);
        }
        ArmsAPMLogger armsAPMLogger = new ArmsAPMLogger(userId, logType);
        armsLoggerMap.put(userLogBeanKey, armsAPMLogger);
        return armsAPMLogger;
    }

    private static final String locateUserHome() {
        String userHome = ArmsLoggerUtils.getSystemProperty("user.home");
        if (ArmsLoggerUtils.isNotBlank(userHome)) {
            if (!userHome.endsWith(File.separator)) {
                userHome = userHome + File.separator;
            }
        } else {
            userHome = "/tmp/";
        }
        return userHome;
    }

    private static final String locateBaseLogPath() {
        String tmpPath = ArmsLoggerUtils.getSystemProperty("JM.LOG.PATH");
        if (ArmsLoggerUtils.isNotBlank(tmpPath)) {
            if (!tmpPath.endsWith(File.separator)) {
                tmpPath = tmpPath + File.separator;
            }
        } else {
            tmpPath = USER_HOME + "logs" + File.separator;
        }
        return tmpPath;
    }

    private static final String locateARMSLogPath() {
        String tmpPath = ArmsLoggerUtils.getSystemProperty("ARMSLOGGER.LOG.PATH");
        if (ArmsLoggerUtils.isNotBlank(tmpPath)) {
            if (!tmpPath.endsWith(File.separator)) {
                tmpPath = tmpPath + File.separator;
            }
        } else {
            tmpPath = BASE_LOG_DIR + "arms" + File.separator + "tracelogs" + File.separator;
        }
        return tmpPath;
    }

    private static final String locateARMSSelfLogPath() {
        return LOG_PATH + "logger-self.log";
    }

    private static final Charset getDefaultOutputCharset() {
        Charset cs;
        String charsetName = ArmsLoggerUtils.getSystemProperty("ARMSLOGGER.CHARSET");
        if (ArmsLoggerUtils.isNotBlank(charsetName)) {
            charsetName = charsetName.trim();
            try {
                cs = Charset.forName(charsetName);
                if (cs != null) {
                    return cs;
                }
            }
            catch (Exception var6) {
                // empty catch block
            }
        }
        try {
            cs = Charset.forName("UTF-8");
        }
        catch (Exception var5) {
            try {
                cs = Charset.forName("GBK");
            }
            catch (Exception var4) {
                cs = Charset.forName("GB18030");
            }
        }
        return cs;
    }

    private static final Appender createSelfLogger() {
        RollingFileAppender selfAppender = new RollingFileAppender(ARMSLOGGER_SELF_LOG_FILE, ArmsLoggerUtils.getSystemPropertyForLong("ARMSLOGGER.LOG.SELF.FILESIZE", 0xC800000L), false);
        selfAppender.setMaxBackupIndex((int)ArmsLoggerUtils.getSystemPropertyForLong("ARMSLOGGER.LOG.SELF.BACKUPSIZE", 1L));
        return new SyncAppender(selfAppender);
    }

    public static void selfLog(String log) {
        try {
            String timestamp = ArmsLoggerUtils.formatTime(System.currentTimeMillis());
            String line = "[" + timestamp + "] " + log + "\r\n";
            selfAppender.append(line);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void selfLog(String log, Throwable e) {
        long now = System.currentTimeMillis();
        if (exceptionBucket.acquire(now)) {
            try {
                String timestamp = ArmsLoggerUtils.formatTime(now);
                StringWriter sw = new StringWriter(4096);
                PrintWriter pw = new PrintWriter((Writer)sw, false);
                pw.append('[').append(timestamp).append("] ").append(log).append("\r\n");
                e.printStackTrace(pw);
                pw.println();
                pw.flush();
                selfAppender.append(sw.toString());
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }
}

