/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.arms.logger;

import com.navercorp.pinpoint.common.arms.logger.ArmsCollectorLoggerEncoder;
import com.navercorp.pinpoint.common.arms.logger.ArmsLoggerDispatch;
import com.navercorp.pinpoint.common.arms.logger.ArmsLoggerUtils;
import com.navercorp.pinpoint.common.arms.logger.AsyncAppender;
import com.navercorp.pinpoint.common.arms.logger.BaseContext;
import com.navercorp.pinpoint.common.arms.logger.LogDaemon;
import com.navercorp.pinpoint.common.arms.logger.RollingFileAppender;
import java.io.File;

public class ArmsAPMLogger {
    final String ARMSLOGGER_LOG_FILE;
    private AsyncAppender bizAppender;
    static final long MAX_ARMS_LOG_FILE_SIZE = 314572800L;
    public static final String CLASS_LOCATION = ArmsLoggerUtils.getClassLocation(ArmsAPMLogger.class);
    public static final int MAX_BIZ_LOG_SIZE = 4096;

    public ArmsAPMLogger(String userId, String logType) {
        this.ARMSLOGGER_LOG_FILE = ArmsLoggerDispatch.LOG_PATH + userId + File.separator + logType + ".log";
        this.selfLog("[ArmsAPMLogger Start] ARMSLOGGER_LOG_FILE: " + this.ARMSLOGGER_LOG_FILE);
        this.init();
    }

    public void logLine(String logContent) {
        BaseContext ctx = new BaseContext();
        ctx.callBackMsg = logContent;
        this.logLine(ctx);
    }

    public void logLine(String level, String traceId, String rpcId, String clazzName, String methodName, String LogType2, String logContent) {
        BaseContext ctx = new BaseContext(traceId, rpcId);
        ctx.setLogLevel(level);
        ctx.setLoggerType(LogType2);
        ctx.setClazzName(clazzName);
        ctx.setMethodName(methodName);
        ctx.callBackMsg = logContent;
        this.logLine(ctx);
    }

    void logLine(BaseContext biz) {
        String logContent = biz.callBackMsg;
        if (logContent == null) {
            this.selfLog("[WARN] ArmsLogger not logged for logContent is null");
            return;
        }
        if (biz.logTime <= 0L) {
            biz.logTime = System.currentTimeMillis();
        }
        if (logContent.length() > 4096) {
            this.bizAppender.append(biz);
            this.bizAppender.flush();
            return;
        }
        this.bizAppender.append(biz);
    }

    private void init() {
        try {
            this.bizAppender = new AsyncAppender((int)ArmsLoggerUtils.getSystemPropertyForLong("ARMS.LOG.BIZ.QUEUESIZE", 5120L), 0);
            RollingFileAppender armsLogger = new RollingFileAppender(this.ARMSLOGGER_LOG_FILE, ArmsLoggerUtils.getSystemPropertyForLong("ARMS.LOG.BIZ.FILESIZE", 314572800L), true);
            armsLogger.setMaxBackupIndex((int)ArmsLoggerUtils.getSystemPropertyForLong("ARMS.LOG.BIZ.BACKUPSIZE", 2L));
            this.bizAppender.start(armsLogger, new ArmsCollectorLoggerEncoder(), "ArmsLoggerLog");
            LogDaemon.watch(this.bizAppender);
        }
        catch (Throwable e) {
            this.selfLog("[ERROR] fail to create ARMS Logger", e);
        }
        try {
            this.selfLog("[INFO] ARMS Logger started (" + CLASS_LOCATION + ")" + ", classloader=" + ArmsAPMLogger.class.getClassLoader() + ", pid=" + ArmsLoggerUtils.getCurrrentPid());
        }
        catch (Throwable e) {
            this.selfLog("[INFO] ARMS Logger started (" + CLASS_LOCATION + "), pid=" + ArmsLoggerUtils.getCurrrentPid());
        }
        try {
            LogDaemon.start();
        }
        catch (Throwable e) {
            this.selfLog("[ERROR] fail to start LogDaemon", e);
        }
    }

    public void selfLog(String log) {
        ArmsLoggerDispatch.selfLog(log);
    }

    public void selfLog(String log, Throwable e) {
        ArmsLoggerDispatch.selfLog(log, e);
    }
}

