/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.arms.eagleeye;

import com.navercorp.pinpoint.common.arms.util.CommonUtils;
import com.navercorp.pinpoint.common.arms.util.FormatUtils;
import java.math.BigInteger;

public class EagleEyeTraceId {
    public static final EagleEyeTraceId INVALID = EagleEyeTraceId.fromLongs(0L, 0L);
    private final long long0;
    private final long long1;
    private transient String EagleEyeTraceIdStr;
    private transient String rootIp;

    private EagleEyeTraceId(long long0, long long1) {
        this.long0 = long0;
        this.long1 = long1;
    }

    public long getLong0() {
        return this.long0;
    }

    public long getLong1() {
        return this.long1;
    }

    public int getVersion() {
        return (int)(this.long1 & 0xFL);
    }

    public char getFlag() {
        return this.getVersion() == 0 ? (char)'0' : EagleEyeTraceId.digitToChar((int)(this.long0 >> 48 & 0xFL));
    }

    public int getSeqNum() {
        return this.getVersion() == 0 ? 0 : (int)(this.long0 & 0xFFFFL);
    }

    public int getPid() {
        return this.getVersion() == 0 ? 0 : (int)(this.long1 >> 16 & 0xFFFFL);
    }

    public long getTimestamp() {
        return this.getVersion() == 0 ? 0L : this.long0 >> 52 & 0xFFFL | this.long0 >> 4 & 0xFFFFFFFF000L;
    }

    public String getRootIp() {
        return this.rootIp;
    }

    public String getEagleEyeTraceIdStr() {
        return this.EagleEyeTraceIdStr;
    }

    public boolean isSampleAccepted(int sampling) {
        return sampling > 1 ? (this.getVersion() != 0 ? this.getSeqNum() % sampling == 0 : this.EagleEyeTraceIdStr.hashCode() % sampling == 0) : true;
    }

    public String toString() {
        return this.EagleEyeTraceIdStr;
    }

    public String toDetailedString() {
        return this.getVersion() == 0 ? "EagleEyeTraceId [" + this.EagleEyeTraceIdStr + ", long0=" + Long.toHexString(this.long0) + ", long1=" + Long.toHexString(this.long1) + "]" : "EagleEyeTraceId [" + this.EagleEyeTraceIdStr + ", long0=" + Long.toHexString(this.long0) + ", long1=" + Long.toHexString(this.long1) + ", rootIp=" + this.getRootIp() + ", timestamp=" + FormatUtils.toDateTimeMillisString(this.getTimestamp()) + ", seqNum=" + this.getSeqNum() + ", flag=" + this.getFlag() + ", pid=" + this.getPid() + "]";
    }

    public static final EagleEyeTraceId fromString(String EagleEyeTraceIdStr) {
        if (EagleEyeTraceIdStr == null) {
            return INVALID;
        }
        int traceLen = EagleEyeTraceIdStr.length();
        if (traceLen < 25) {
            return EagleEyeTraceId.handleVersion0(EagleEyeTraceIdStr);
        }
        char firstTimeChar = EagleEyeTraceIdStr.charAt(8);
        if (firstTimeChar >= '1' && firstTimeChar <= '3') {
            int version = 1;
            int ipA = EagleEyeTraceId.charToDigit(EagleEyeTraceIdStr.charAt(0)) * 16 + EagleEyeTraceId.charToDigit(EagleEyeTraceIdStr.charAt(1));
            int ipB = EagleEyeTraceId.charToDigit(EagleEyeTraceIdStr.charAt(2)) * 16 + EagleEyeTraceId.charToDigit(EagleEyeTraceIdStr.charAt(3));
            int ipC = EagleEyeTraceId.charToDigit(EagleEyeTraceIdStr.charAt(4)) * 16 + EagleEyeTraceId.charToDigit(EagleEyeTraceIdStr.charAt(5));
            int ipD = EagleEyeTraceId.charToDigit(EagleEyeTraceIdStr.charAt(6)) * 16 + EagleEyeTraceId.charToDigit(EagleEyeTraceIdStr.charAt(7));
            if (ipA >= 0 && ipA <= 255 && ipB >= 0 && ipB <= 255 && ipC >= 0 && ipC <= 255 && ipD >= 0 && ipD <= 255) {
                long long0 = 0L;
                long long1 = 0L;
                String rootIp = ipA + "." + ipB + "." + ipC + "." + ipD;
                long1 |= ((long)ipA & 0xFFL) << 56;
                long1 |= ((long)ipB & 0xFFL) << 48;
                long1 |= ((long)ipC & 0xFFL) << 40;
                long1 |= ((long)ipD & 0xFFL) << 32;
                long timestamp = CommonUtils.parseLongQuietly(EagleEyeTraceIdStr.substring(8, 21), 0L);
                long0 |= (timestamp & 0xFFFL) << 52;
                long0 |= timestamp << 4 & 0xFFFFFFFF0000L;
                int seqNum = EagleEyeTraceIdStr.charAt(21) - 48;
                seqNum = seqNum * 10 + EagleEyeTraceIdStr.charAt(22) - 48;
                seqNum = seqNum * 10 + EagleEyeTraceIdStr.charAt(23) - 48;
                if ((seqNum = seqNum * 10 + EagleEyeTraceIdStr.charAt(24) - 48) >= 1000 && seqNum <= 9999) {
                    long0 |= (long)seqNum & 0xFFFFL;
                    if (traceLen > 25) {
                        int flag = EagleEyeTraceId.charToDigit(EagleEyeTraceIdStr.charAt(25));
                        long0 |= ((long)flag & 0xFL) << 48;
                        if (traceLen == 30) {
                            int pid;
                            try {
                                pid = Integer.parseInt(EagleEyeTraceIdStr.substring(26, 30), 16);
                            }
                            catch (NumberFormatException var19) {
                                return INVALID;
                            }
                            long1 |= ((long)pid & 0xFFFFL) << 16;
                            version = 2;
                        } else if (traceLen != 26) {
                            return INVALID;
                        }
                    } else {
                        boolean var20 = false;
                    }
                    EagleEyeTraceId EagleEyeTraceId2 = new EagleEyeTraceId(long0, long1 |= 0xFL & (long)version);
                    EagleEyeTraceId2.rootIp = rootIp;
                    EagleEyeTraceId2.EagleEyeTraceIdStr = EagleEyeTraceIdStr;
                    return EagleEyeTraceId2;
                }
                return INVALID;
            }
            return INVALID;
        }
        return INVALID;
    }

    private static EagleEyeTraceId handleVersion0(String EagleEyeTraceIdStr) {
        int traceLen = EagleEyeTraceIdStr.length();
        if (traceLen != 0 && EagleEyeTraceIdStr.charAt(0) != '0') {
            try {
                long long0;
                if (traceLen <= 15) {
                    long0 = Long.parseLong(EagleEyeTraceIdStr, 16);
                } else {
                    if (traceLen != 16) {
                        return INVALID;
                    }
                    long0 = new BigInteger(EagleEyeTraceIdStr, 16).longValue();
                }
                EagleEyeTraceId EagleEyeTraceId2 = new EagleEyeTraceId(long0, 0L);
                EagleEyeTraceId2.EagleEyeTraceIdStr = EagleEyeTraceIdStr;
                EagleEyeTraceId2.rootIp = "(?)";
                return EagleEyeTraceId2;
            }
            catch (NumberFormatException var5) {
                return INVALID;
            }
        }
        return INVALID;
    }

    public static final EagleEyeTraceId fromLongs(long long0, long long1) {
        EagleEyeTraceId EagleEyeTraceId2 = new EagleEyeTraceId(long0, long1);
        int version = EagleEyeTraceId2.getVersion();
        if (version == 0) {
            EagleEyeTraceId2.EagleEyeTraceIdStr = Long.toHexString(long0);
            EagleEyeTraceId2.rootIp = "(?)";
            return EagleEyeTraceId2;
        }
        long timelo = long0 >> 52 & 0xFFFL;
        int flag = (int)(long0 >> 48 & 0xFL);
        long timehi = long0 >> 4 & 0xFFFFFFFF000L;
        int seqNum = (int)(long0 & 0xFFFFL);
        int ipA = (int)(long1 >> 56 & 0xFFL);
        int ipB = (int)(long1 >> 48 & 0xFFL);
        int ipC = (int)(long1 >> 40 & 0xFFL);
        int ipD = (int)(long1 >> 32 & 0xFFL);
        int pid = (int)(long1 >> 16 & 0xFFFFL);
        EagleEyeTraceId2.rootIp = ipA + "." + ipB + "." + ipC + "." + ipD;
        long timestamp = timehi | timelo;
        StringBuilder appender = new StringBuilder(32);
        appender.append(EagleEyeTraceId.digitToChar(0xF & ipA >> 4)).append(EagleEyeTraceId.digitToChar(0xF & ipA)).append(EagleEyeTraceId.digitToChar(0xF & ipB >> 4)).append(EagleEyeTraceId.digitToChar(0xF & ipB)).append(EagleEyeTraceId.digitToChar(0xF & ipC >> 4)).append(EagleEyeTraceId.digitToChar(0xF & ipC)).append(EagleEyeTraceId.digitToChar(0xF & ipD >> 4)).append(EagleEyeTraceId.digitToChar(0xF & ipD)).append(timestamp).append(seqNum);
        if (version > 1) {
            appender.append(EagleEyeTraceId.digitToChar(0xF & flag));
            appender.append(EagleEyeTraceId.digitToChar(0xF & pid >> 12)).append(EagleEyeTraceId.digitToChar(0xF & pid >> 8)).append(EagleEyeTraceId.digitToChar(0xF & pid >> 4)).append(EagleEyeTraceId.digitToChar(0xF & pid));
        } else if (flag != 0) {
            appender.append(EagleEyeTraceId.digitToChar(0xF & flag));
        }
        EagleEyeTraceId2.EagleEyeTraceIdStr = appender.toString();
        return EagleEyeTraceId2;
    }

    private static final char digitToChar(int digit) {
        if (digit >= 0) {
            if (digit < 10) {
                return (char)(48 + digit);
            }
            if (digit < 16) {
                return (char)(87 + digit);
            }
        }
        return '\u0000';
    }

    private static final int charToDigit(char ch) {
        return ch <= '9' && ch >= '0' ? ch - 48 : (ch >= 'a' && ch <= 'f' ? ch - 97 + 10 : -1000);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (int)(this.long0 ^ this.long0 >>> 32);
        result = 31 * result + (int)(this.long1 ^ this.long1 >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EagleEyeTraceId other = (EagleEyeTraceId)obj;
        return this.long0 != other.long0 ? false : this.long1 == other.long1;
    }

    public static boolean isNewVersion(String EagleEyeTraceId2) {
        return EagleEyeTraceId2 != null && EagleEyeTraceId2.length() >= 25 && EagleEyeTraceId2.charAt(8) == '1';
    }

    public static String getRootIp(String EagleEyeTraceId2, String defaultValue) {
        if (EagleEyeTraceId.isNewVersion(EagleEyeTraceId2)) {
            int ipA = EagleEyeTraceId.charToDigit(EagleEyeTraceId2.charAt(0)) * 16 + EagleEyeTraceId.charToDigit(EagleEyeTraceId2.charAt(1));
            int ipB = EagleEyeTraceId.charToDigit(EagleEyeTraceId2.charAt(2)) * 16 + EagleEyeTraceId.charToDigit(EagleEyeTraceId2.charAt(3));
            int ipC = EagleEyeTraceId.charToDigit(EagleEyeTraceId2.charAt(4)) * 16 + EagleEyeTraceId.charToDigit(EagleEyeTraceId2.charAt(5));
            int ipD = EagleEyeTraceId.charToDigit(EagleEyeTraceId2.charAt(6)) * 16 + EagleEyeTraceId.charToDigit(EagleEyeTraceId2.charAt(7));
            if (ipA >= 0 && ipA <= 255 && ipB >= 0 && ipB <= 255 && ipC >= 0 && ipC <= 255 && ipD >= 0 && ipD <= 255) {
                return ipA + "." + ipB + "." + ipC + "." + ipD;
            }
        }
        return defaultValue;
    }

    public static long getTimestamp(String EagleEyeTraceId2, long defaultValue) {
        return EagleEyeTraceId.isNewVersion(EagleEyeTraceId2) ? CommonUtils.parseLongQuietly(EagleEyeTraceId2.substring(8, 21), defaultValue) : defaultValue;
    }

    public static int getSeqNum(String EagleEyeTraceId2, int defaultValue) {
        int seqNum;
        if (EagleEyeTraceId.isNewVersion(EagleEyeTraceId2) && ((seqNum = CommonUtils.parseIntQuietly(EagleEyeTraceId2.substring(21, 25), defaultValue)) < 1000 || seqNum > 9999)) {
            return defaultValue;
        }
        return defaultValue;
    }

    public static boolean isSampleAccepted(String EagleEyeTraceId2, int sampling) {
        if (sampling > 1) {
            if (EagleEyeTraceId2.length() >= 25) {
                int count = EagleEyeTraceId2.charAt(21) - 48;
                count = count * 10 + EagleEyeTraceId2.charAt(22) - 48;
                count = count * 10 + EagleEyeTraceId2.charAt(23) - 48;
                return (count = count * 10 + EagleEyeTraceId2.charAt(24) - 48) % sampling == 0;
            }
            return EagleEyeTraceId2.hashCode() % sampling == 0;
        }
        return true;
    }

    public static void main(String[] args) {
        EagleEyeTraceId traceId = EagleEyeTraceId.fromString("1e05609d15051015165851002d1da1");
        System.out.println(traceId.getLong0());
        System.out.println(traceId.getLong1());
        System.out.println(traceId.getVersion());
    }
}

