/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.arms.eagleeye;

import com.navercorp.pinpoint.common.arms.logger.FastDateFormat;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.zip.CRC32;
import sun.misc.Unsafe;

public final class EagleEyeCoreUtils {
    public static final String EMPTY_STRING = "";
    public static final String NEWLINE = "\r\n";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String LOCAL_IP_ADDRESS = EagleEyeCoreUtils.getLocalInetAddress();
    private static final int PID = EagleEyeCoreUtils.doGetCurrrentPid();
    private static final String PID_STR = String.valueOf(PID);
    private static final ThreadLocal<FastDateFormat> dateFmt = new ThreadLocal<FastDateFormat>(){

        @Override
        protected FastDateFormat initialValue() {
            return new FastDateFormat();
        }
    };
    private static final Unsafe UNSAFE = EagleEyeCoreUtils.doGetUnsafe();

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String checkNotNullEmpty(String value, String name) throws IllegalArgumentException {
        if (EagleEyeCoreUtils.isBlank(value)) {
            throw new IllegalArgumentException(name + " is null or empty");
        }
        return value;
    }

    public static <T> T checkNotNull(T value, String name) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException(name + " is null");
        }
        return value;
    }

    public static <T> T defaultIfNull(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static boolean isNotBlank(String str) {
        return !EagleEyeCoreUtils.isBlank(str);
    }

    public static boolean isNotEmpty(String str) {
        return str != null && str.length() > 0;
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String[] split(String str, char separatorChar) {
        return EagleEyeCoreUtils.splitWorker(str, separatorChar, false);
    }

    private static String[] splitWorker(String str, char separatorChar, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        while (i < len) {
            if (str.charAt(i) == separatorChar) {
                if (match || preserveAllTokens) {
                    list.add(str.substring(start, i));
                    match = false;
                    lastMatch = true;
                }
                start = ++i;
                continue;
            }
            lastMatch = false;
            match = true;
            ++i;
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static StringBuilder appendWithBlankCheck(String str, String defaultValue, StringBuilder appender) {
        if (EagleEyeCoreUtils.isNotBlank(str)) {
            appender.append(str);
        } else {
            appender.append(defaultValue);
        }
        return appender;
    }

    public static StringBuilder appendWithNullCheck(Object obj, String defaultValue, StringBuilder appender) {
        if (obj != null) {
            appender.append(obj.toString());
        } else {
            appender.append(defaultValue);
        }
        return appender;
    }

    public static StringBuilder appendLog(String str, StringBuilder appender, char delimiter) {
        if (str != null) {
            int len = str.length();
            appender.ensureCapacity(appender.length() + len);
            for (int i = 0; i < len; ++i) {
                char c = str.charAt(i);
                if (c == '\n' || c == '\r' || c == delimiter) {
                    c = ' ';
                }
                appender.append(c);
            }
        }
        return appender;
    }

    public static String filterInvalidCharacters(String str) {
        StringBuilder appender = new StringBuilder(str.length());
        return EagleEyeCoreUtils.appendLog(str, appender, '|').toString();
    }

    public static String digest(String str) {
        CRC32 crc = new CRC32();
        crc.update(str.getBytes());
        return Long.toHexString(crc.getValue());
    }

    public static String formatTime(long timestamp) {
        return dateFmt.get().format(timestamp);
    }

    public static String getUriFromUrl(String url) {
        int start;
        int len = url.length();
        if (len <= 7) {
            return url;
        }
        start = url.startsWith("http://") ? 7 : ((start = url.indexOf("://")) != -1 ? (start += 3) : 0);
        int end = url.charAt(len - 1) == '/' ? len - 1 : len;
        int istart = url.indexOf(47, start);
        if (istart >= 0 && istart < end) {
            return url.substring(istart, end);
        }
        return url.substring(start, end);
    }

    public static boolean isDocker() {
        File d = new File("/.dockerenv");
        if (d.exists()) {
            return true;
        }
        d = new File("/proc/1/cgroup");
        if (d.exists()) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(d)));
                while ((line = br.readLine()) != null) {
                    if (!line.contains("docker")) continue;
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static String getLocalInetAddress() {
        String localIp = EagleEyeCoreUtils.getSystemProperty("EAGLEEYE.LOCAL.IP");
        if (EagleEyeCoreUtils.isNotBlank(localIp) && localIp.length() >= 7 && Character.isDigit(localIp.charAt(0)) && Character.isDigit(localIp.charAt(localIp.length() - 1))) {
            return localIp;
        }
        String inet = EagleEyeCoreUtils.getSystemProperty("NETWORK.INTERFACE");
        if (EagleEyeCoreUtils.isBlank(inet) && EagleEyeCoreUtils.isDocker()) {
            inet = "eth0";
        }
        if (EagleEyeCoreUtils.isNotBlank(inet)) {
            try {
                NetworkInterface ni = NetworkInterface.getByName(inet);
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (address.isLoopbackAddress() || address.getHostAddress().indexOf(":") != -1) continue;
                    return address.getHostAddress();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress address = null;
            while (interfaces.hasMoreElements()) {
                NetworkInterface ni = interfaces.nextElement();
                String displayName = ni.getDisplayName();
                if (displayName != null && (displayName.startsWith("virbr") || displayName.equals("docker0"))) continue;
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    address = addresses.nextElement();
                    if (address.isLoopbackAddress() || address.getHostAddress().indexOf(":") != -1) continue;
                    return address.getHostAddress();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "127.0.0.1";
    }

    public static String getLocalAddress() {
        return LOCAL_IP_ADDRESS;
    }

    public static boolean isTraceSampled(String traceId, int samplingInterval) {
        if (traceId == null) {
            return false;
        }
        if (samplingInterval <= 1 || samplingInterval >= 10000) {
            return true;
        }
        int len = traceId.length();
        if (len < 25) {
            return traceId.hashCode() % samplingInterval == 0;
        }
        if (len >= 26 && traceId.charAt(25) == 'f') {
            return true;
        }
        int count = traceId.charAt(21) - 48;
        count = count * 10 + traceId.charAt(22) - 48;
        count = count * 10 + traceId.charAt(23) - 48;
        return (count = count * 10 + traceId.charAt(24) - 48) % samplingInterval == 0;
    }

    private static int doGetCurrrentPid() {
        try {
            RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
            String name = runtime.getName();
            return Integer.parseInt(name.substring(0, name.indexOf(64)));
        }
        catch (Throwable t) {
            return 0;
        }
    }

    public static int getCurrrentPid() {
        return PID;
    }

    public static String getCurrrentPidString() {
        return PID_STR;
    }

    public static String getSystemProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static long getSystemPropertyForLong(String key, long defaultValue) {
        try {
            return Long.parseLong(System.getProperty(key));
        }
        catch (Throwable t) {
            return defaultValue;
        }
    }

    public static boolean isValidTraceId(String traceId) {
        int i;
        int len;
        if (traceId == null || (len = traceId.length()) == 0) {
            return false;
        }
        if (len < 25) {
            return EagleEyeCoreUtils.handleOldVersion(traceId);
        }
        if (len > 48) {
            return false;
        }
        for (int i2 = 0; i2 < 8; ++i2) {
            if (EagleEyeCoreUtils.isHexNumeric(traceId.charAt(i2))) continue;
            return false;
        }
        char firstTimeChar = traceId.charAt(8);
        if (firstTimeChar < '1' || firstTimeChar > '3') {
            return false;
        }
        for (i = 9; i < 25; ++i) {
            if (EagleEyeCoreUtils.isNumeric(traceId.charAt(i))) continue;
            return false;
        }
        for (i = 25; i < len; ++i) {
            if (EagleEyeCoreUtils.isHexNumeric(traceId.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean handleOldVersion(String traceId) {
        if (traceId.charAt(0) == '0') {
            return false;
        }
        for (int i = 0; i < traceId.length(); ++i) {
            if (EagleEyeCoreUtils.isHexNumeric(traceId.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidRpcId(String rpcId) {
        int len;
        if (rpcId == null || (len = rpcId.length()) == 0) {
            return false;
        }
        if (len > 64) {
            return false;
        }
        if (!EagleEyeCoreUtils.isNumeric(rpcId.charAt(0))) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            char ch = rpcId.charAt(i);
            if (EagleEyeCoreUtils.isNumeric(ch) || ch == '.') continue;
            return false;
        }
        return true;
    }

    public static final boolean isHexNumeric(char ch) {
        return ch >= 'a' && ch <= 'f' || ch >= '0' && ch <= '9';
    }

    public static final boolean isNumeric(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static final boolean deleteQuietly(File file) {
        if (file == null) {
            return false;
        }
        try {
            File[] files;
            if (file.isDirectory() && (files = file.listFiles()) != null) {
                for (File f : files) {
                    EagleEyeCoreUtils.deleteQuietly(f);
                }
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            return file.delete();
        }
        catch (Exception ignored) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String readLineFile(File file) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(file), 128);
            String string = br.readLine();
            return string;
        }
        catch (Exception e) {
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static final void shutdownThreadPool(ExecutorService pool, long awaitTimeMillis) {
        try {
            pool.shutdown();
            boolean done = false;
            if (awaitTimeMillis > 0L) {
                try {
                    done = pool.awaitTermination(awaitTimeMillis, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (!done) {
                pool.shutdownNow();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Unsafe getUnsafe() {
        return UNSAFE;
    }

    private static Unsafe doGetUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (Throwable tryReflectionInstead) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Class<Unsafe> k = Unsafe.class;
                        for (Field f : k.getDeclaredFields()) {
                            f.setAccessible(true);
                            Object x = f.get(null);
                            if (!k.isInstance(x)) continue;
                            return (Unsafe)k.cast(x);
                        }
                        throw new NoSuchFieldError("the Unsafe");
                    }
                });
            }
            catch (Throwable t) {
                return null;
            }
        }
    }
}

