/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slots.statistic.metric;

import com.alibaba.csp.sentinel.Constants;
import com.alibaba.csp.sentinel.node.metric.MetricNode;
import com.alibaba.csp.sentinel.slots.statistic.MetricEvent;
import com.alibaba.csp.sentinel.slots.statistic.base.LeapArray;
import com.alibaba.csp.sentinel.slots.statistic.base.WindowWrap;
import com.alibaba.csp.sentinel.slots.statistic.data.MetricBucket;
import com.alibaba.csp.sentinel.slots.statistic.metric.BucketLeapArray;
import com.alibaba.csp.sentinel.slots.statistic.metric.Metric;
import com.alibaba.csp.sentinel.slots.statistic.metric.occupy.OccupiableBucketLeapArray;
import com.alibaba.csp.sentinel.util.function.Predicate;
import java.util.ArrayList;
import java.util.List;

public class ArrayMetric
implements Metric {
    private final LeapArray<MetricBucket> data;

    public ArrayMetric(int sampleCount, int intervalInMs) {
        this.data = new OccupiableBucketLeapArray(sampleCount, intervalInMs);
    }

    public ArrayMetric(int sampleCount, int intervalInMs, boolean enableOccupy) {
        this.data = enableOccupy ? new OccupiableBucketLeapArray(sampleCount, intervalInMs) : new BucketLeapArray(sampleCount, intervalInMs);
    }

    public ArrayMetric(LeapArray<MetricBucket> array) {
        this.data = array;
    }

    @Override
    public long success() {
        this.data.currentWindow();
        long success = 0L;
        List<MetricBucket> list = this.data.values();
        for (MetricBucket window : list) {
            success += window.success();
        }
        return success;
    }

    @Override
    public long maxSuccess() {
        this.data.currentWindow();
        long success = 0L;
        List<MetricBucket> list = this.data.values();
        for (MetricBucket window : list) {
            if (window.success() <= success) continue;
            success = window.success();
        }
        return Math.max(success, 1L);
    }

    @Override
    public long exception() {
        this.data.currentWindow();
        long exception = 0L;
        List<MetricBucket> list = this.data.values();
        for (MetricBucket window : list) {
            exception += window.exception();
        }
        return exception;
    }

    @Override
    public long block() {
        this.data.currentWindow();
        long block = 0L;
        List<MetricBucket> list = this.data.values();
        for (MetricBucket window : list) {
            block += window.block();
        }
        return block;
    }

    @Override
    public long pass() {
        this.data.currentWindow();
        long pass = 0L;
        List<MetricBucket> list = this.data.values();
        for (MetricBucket window : list) {
            pass += window.pass();
        }
        return pass;
    }

    @Override
    public long occupiedPass() {
        this.data.currentWindow();
        long pass = 0L;
        List<MetricBucket> list = this.data.values();
        for (MetricBucket window : list) {
            pass += window.occupiedPass();
        }
        return pass;
    }

    @Override
    public long rt() {
        this.data.currentWindow();
        long rt = 0L;
        List<MetricBucket> list = this.data.values();
        for (MetricBucket window : list) {
            rt += window.rt();
        }
        return rt;
    }

    @Override
    public long minRt() {
        this.data.currentWindow();
        long rt = Constants.TIME_DROP_VALVE;
        List<MetricBucket> list = this.data.values();
        for (MetricBucket window : list) {
            if (window.minRt() >= rt) continue;
            rt = window.minRt();
        }
        return Math.max(1L, rt);
    }

    @Override
    public List<MetricNode> details() {
        ArrayList<MetricNode> details = new ArrayList<MetricNode>();
        this.data.currentWindow();
        List<WindowWrap<MetricBucket>> list = this.data.list();
        for (WindowWrap<MetricBucket> window : list) {
            if (window == null) continue;
            details.add(this.fromBucket(window));
        }
        return details;
    }

    @Override
    public List<MetricNode> detailsOnCondition(Predicate<Long> timePredicate) {
        ArrayList<MetricNode> details = new ArrayList<MetricNode>();
        this.data.currentWindow();
        List<WindowWrap<MetricBucket>> list = this.data.list();
        for (WindowWrap<MetricBucket> window : list) {
            if (window == null || timePredicate != null && !timePredicate.test(window.windowStart())) continue;
            details.add(this.fromBucket(window));
        }
        return details;
    }

    private MetricNode fromBucket(WindowWrap<MetricBucket> wrap) {
        MetricNode node = new MetricNode();
        node.setBlockQps(wrap.value().block());
        node.setExceptionQps(wrap.value().exception());
        node.setPassQps(wrap.value().pass());
        long successQps = wrap.value().success();
        node.setSuccessQps(successQps);
        if (successQps != 0L) {
            node.setRt(wrap.value().rt() / successQps);
        } else {
            node.setRt(wrap.value().rt());
        }
        node.setTimestamp(wrap.windowStart());
        node.setOccupiedPassQps(wrap.value().occupiedPass());
        return node;
    }

    @Override
    public MetricBucket[] windows() {
        this.data.currentWindow();
        return this.data.values().toArray(new MetricBucket[0]);
    }

    @Override
    public void addException(int count) {
        WindowWrap<MetricBucket> wrap = this.data.currentWindow();
        wrap.value().addException(count);
    }

    @Override
    public void addBlock(int count) {
        WindowWrap<MetricBucket> wrap = this.data.currentWindow();
        wrap.value().addBlock(count);
    }

    @Override
    public void addWaiting(long time, int acquireCount) {
        this.data.addWaiting(time, acquireCount);
    }

    @Override
    public void addOccupiedPass(int acquireCount) {
        WindowWrap<MetricBucket> wrap = this.data.currentWindow();
        wrap.value().addOccupiedPass(acquireCount);
    }

    @Override
    public void addSuccess(int count) {
        WindowWrap<MetricBucket> wrap = this.data.currentWindow();
        wrap.value().addSuccess(count);
    }

    @Override
    public void addPass(int count) {
        WindowWrap<MetricBucket> wrap = this.data.currentWindow();
        wrap.value().addPass(count);
    }

    @Override
    public void addRT(long rt) {
        WindowWrap<MetricBucket> wrap = this.data.currentWindow();
        wrap.value().addRT(rt);
    }

    @Override
    public void debug() {
        this.data.debug(System.currentTimeMillis());
    }

    @Override
    public long previousWindowBlock() {
        WindowWrap<MetricBucket> wrap = this.data.currentWindow();
        wrap = this.data.getPreviousWindow();
        if (wrap == null) {
            return 0L;
        }
        return wrap.value().block();
    }

    @Override
    public long previousWindowPass() {
        WindowWrap<MetricBucket> wrap = this.data.currentWindow();
        wrap = this.data.getPreviousWindow();
        if (wrap == null) {
            return 0L;
        }
        return wrap.value().pass();
    }

    public void add(MetricEvent event, long count) {
        this.data.currentWindow().value().add(event, count);
    }

    public long getCurrentCount(MetricEvent event) {
        return this.data.currentWindow().value().get(event);
    }

    public long getSum(MetricEvent event) {
        this.data.currentWindow();
        long sum = 0L;
        List<MetricBucket> buckets = this.data.values();
        for (MetricBucket bucket : buckets) {
            sum += bucket.get(event);
        }
        return sum;
    }

    public double getAvg(MetricEvent event) {
        return (double)this.getSum(event) / this.data.getIntervalInSecond();
    }

    @Override
    public long getWindowPass(long timeMillis) {
        MetricBucket bucket = this.data.getWindowValue(timeMillis);
        if (bucket == null) {
            return 0L;
        }
        return bucket.pass();
    }

    @Override
    public long waiting() {
        return this.data.currentWaiting();
    }

    @Override
    public double getWindowIntervalInSec() {
        return this.data.getIntervalInSecond();
    }

    @Override
    public int getSampleCount() {
        return this.data.getSampleCount();
    }
}

