/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.slotchain;

import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slotchain.ProcessorSlotChain;
import com.alibaba.csp.sentinel.slotchain.SlotChainBuilder;
import com.alibaba.csp.sentinel.slots.DefaultSlotChainBuilder;
import java.util.ArrayList;
import java.util.ServiceLoader;

public final class SlotChainProvider {
    private static volatile SlotChainBuilder builder = null;
    private static final ServiceLoader<SlotChainBuilder> LOADER = ServiceLoader.load(SlotChainBuilder.class);

    public static ProcessorSlotChain newSlotChain() {
        if (builder != null) {
            return builder.build();
        }
        SlotChainProvider.resolveSlotChainBuilder();
        if (builder == null) {
            RecordLog.warn("[SlotChainProvider] Wrong state when resolving slot chain builder, using default", new Object[0]);
            builder = new DefaultSlotChainBuilder();
        }
        return builder.build();
    }

    private static void resolveSlotChainBuilder() {
        ArrayList<SlotChainBuilder> list = new ArrayList<SlotChainBuilder>();
        boolean hasOther = false;
        for (SlotChainBuilder builder : LOADER) {
            if (builder.getClass() == DefaultSlotChainBuilder.class) continue;
            hasOther = true;
            list.add(builder);
        }
        builder = hasOther ? (SlotChainBuilder)list.get(0) : new DefaultSlotChainBuilder();
        RecordLog.info("[SlotChainProvider] Global slot chain builder resolved: " + builder.getClass().getCanonicalName(), new Object[0]);
    }

    private SlotChainProvider() {
    }
}

