/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.command.handler;

import com.alibaba.csp.sentinel.Constants;
import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.command.annotation.CommandMapping;
import com.alibaba.csp.sentinel.log.RecordLog;

@CommandMapping(name="setSwitch", desc="set sentinel switch, accept param: value={true|false}")
public class OnOffSetCommandHandler
implements CommandHandler<String> {
    @Override
    public CommandResponse<String> handle(CommandRequest request) {
        String value = request.getParam("value");
        try {
            Constants.ON = Boolean.valueOf(value);
        }
        catch (Exception e) {
            RecordLog.info("Bad value when setting global switch", e);
        }
        String info = "Sentinel set switch value: " + value;
        RecordLog.info(info, new Object[0]);
        return CommandResponse.ofSuccess(info);
    }
}

