/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.server.processor;

import com.alibaba.csp.sentinel.cluster.TokenResult;
import com.alibaba.csp.sentinel.cluster.TokenService;
import com.alibaba.csp.sentinel.cluster.annotation.RequestType;
import com.alibaba.csp.sentinel.cluster.request.ClusterRequest;
import com.alibaba.csp.sentinel.cluster.request.data.ParamFlowRequestData;
import com.alibaba.csp.sentinel.cluster.response.ClusterResponse;
import com.alibaba.csp.sentinel.cluster.response.data.FlowTokenResponseData;
import com.alibaba.csp.sentinel.cluster.server.TokenServiceProvider;
import com.alibaba.csp.sentinel.cluster.server.processor.RequestProcessor;
import java.util.Collection;

@RequestType(value=2)
public class ParamFlowRequestProcessor
implements RequestProcessor<ParamFlowRequestData, FlowTokenResponseData> {
    @Override
    public ClusterResponse<FlowTokenResponseData> processRequest(ClusterRequest<ParamFlowRequestData> request) {
        TokenService tokenService = TokenServiceProvider.getService();
        long flowId = request.getData().getFlowId();
        int count = request.getData().getCount();
        Collection<Object> args = request.getData().getParams();
        TokenResult result = tokenService.requestParamToken(flowId, count, args);
        return this.toResponse(result, request);
    }

    private ClusterResponse<FlowTokenResponseData> toResponse(TokenResult result, ClusterRequest request) {
        return new ClusterResponse<FlowTokenResponseData>(request.getId(), request.getType(), result.getStatus(), new FlowTokenResponseData().setRemainingCount(result.getRemaining()).setWaitInMs(0));
    }
}

