/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.server.connection;

import com.alibaba.csp.sentinel.cluster.server.connection.ConnectionDescriptor;
import com.alibaba.csp.sentinel.util.AssertUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class ConnectionGroup {
    private final String namespace;
    private final Set<ConnectionDescriptor> connectionSet = Collections.synchronizedSet(new HashSet());
    private final AtomicInteger connectedCount = new AtomicInteger();

    public ConnectionGroup(String namespace) {
        AssertUtil.notEmpty(namespace, "namespace cannot be empty");
        this.namespace = namespace;
    }

    public ConnectionGroup() {
        this("default");
    }

    public ConnectionGroup addConnection(String address) {
        AssertUtil.notEmpty(address, "address cannot be empty");
        String[] ip = address.split(":");
        String host = ip != null && ip.length >= 1 ? ip[0] : address;
        boolean newAdded = this.connectionSet.add(new ConnectionDescriptor().setAddress(address).setHost(host));
        if (newAdded) {
            this.connectedCount.incrementAndGet();
        }
        return this;
    }

    public ConnectionGroup removeConnection(String address) {
        AssertUtil.notEmpty(address, "address cannot be empty");
        if (this.connectionSet.remove(new ConnectionDescriptor().setAddress(address))) {
            this.connectedCount.decrementAndGet();
        }
        return this;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Set<ConnectionDescriptor> getConnectionSet() {
        return this.connectionSet;
    }

    public int getConnectedCount() {
        return this.connectedCount.get();
    }
}

