/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.server.config;

import com.alibaba.csp.sentinel.cluster.flow.rule.ClusterFlowRuleManager;
import com.alibaba.csp.sentinel.cluster.flow.rule.ClusterParamFlowRuleManager;
import com.alibaba.csp.sentinel.cluster.flow.statistic.ClusterMetricStatistics;
import com.alibaba.csp.sentinel.cluster.flow.statistic.ClusterParamMetricStatistics;
import com.alibaba.csp.sentinel.cluster.flow.statistic.limit.GlobalRequestLimiter;
import com.alibaba.csp.sentinel.cluster.registry.ConfigSupplierRegistry;
import com.alibaba.csp.sentinel.cluster.server.config.ServerFlowConfig;
import com.alibaba.csp.sentinel.cluster.server.config.ServerTransportConfig;
import com.alibaba.csp.sentinel.cluster.server.config.ServerTransportConfigObserver;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import com.alibaba.csp.sentinel.property.PropertyListener;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleUtil;
import com.alibaba.csp.sentinel.util.AssertUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class ClusterServerConfigManager {
    private static boolean embedded = false;
    private static volatile int port = 18730;
    private static volatile int idleSeconds = 600;
    private static volatile Set<String> namespaceSet = Collections.singleton("default");
    private static volatile double exceedCount = 1.0;
    private static volatile double maxOccupyRatio = 1.0;
    private static volatile int intervalMs = 1000;
    private static volatile int sampleCount = 10;
    private static volatile double maxAllowedQps = 30000.0;
    private static final Map<String, ServerFlowConfig> NAMESPACE_CONF = new ConcurrentHashMap<String, ServerFlowConfig>();
    private static final List<ServerTransportConfigObserver> TRANSPORT_CONFIG_OBSERVERS = new ArrayList<ServerTransportConfigObserver>();
    private static SentinelProperty<ServerTransportConfig> transportConfigProperty = new DynamicSentinelProperty<ServerTransportConfig>();
    private static SentinelProperty<Set<String>> namespaceSetProperty = new DynamicSentinelProperty<Set<String>>();
    private static SentinelProperty<ServerFlowConfig> globalFlowProperty = new DynamicSentinelProperty<ServerFlowConfig>();
    private static final PropertyListener<ServerTransportConfig> TRANSPORT_PROPERTY_LISTENER = new ServerGlobalTransportPropertyListener();
    private static final PropertyListener<ServerFlowConfig> GLOBAL_FLOW_PROPERTY_LISTENER = new ServerGlobalFlowPropertyListener();
    private static final PropertyListener<Set<String>> NAMESPACE_SET_PROPERTY_LISTENER = new ServerNamespaceSetPropertyListener();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerNamespaceSetProperty(SentinelProperty<Set<String>> property) {
        AssertUtil.notNull(property, "namespace set dynamic property cannot be null");
        PropertyListener<Set<String>> propertyListener = NAMESPACE_SET_PROPERTY_LISTENER;
        synchronized (propertyListener) {
            RecordLog.info("[ClusterServerConfigManager] Registering new namespace set dynamic property to Sentinel server config manager", new Object[0]);
            namespaceSetProperty.removeListener(NAMESPACE_SET_PROPERTY_LISTENER);
            property.addListener(NAMESPACE_SET_PROPERTY_LISTENER);
            namespaceSetProperty = property;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerServerTransportProperty(SentinelProperty<ServerTransportConfig> property) {
        AssertUtil.notNull(property, "cluster server transport config dynamic property cannot be null");
        PropertyListener<ServerTransportConfig> propertyListener = TRANSPORT_PROPERTY_LISTENER;
        synchronized (propertyListener) {
            RecordLog.info("[ClusterServerConfigManager] Registering new server transport dynamic property to Sentinel server config manager", new Object[0]);
            transportConfigProperty.removeListener(TRANSPORT_PROPERTY_LISTENER);
            property.addListener(TRANSPORT_PROPERTY_LISTENER);
            transportConfigProperty = property;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerGlobalServerFlowProperty(SentinelProperty<ServerFlowConfig> property) {
        AssertUtil.notNull(property, "cluster server flow config dynamic property cannot be null");
        PropertyListener<ServerFlowConfig> propertyListener = GLOBAL_FLOW_PROPERTY_LISTENER;
        synchronized (propertyListener) {
            RecordLog.info("[ClusterServerConfigManager] Registering new server global flow dynamic property to Sentinel server config manager", new Object[0]);
            globalFlowProperty.removeListener(GLOBAL_FLOW_PROPERTY_LISTENER);
            property.addListener(GLOBAL_FLOW_PROPERTY_LISTENER);
            globalFlowProperty = property;
        }
    }

    public static void loadServerNamespaceSet(Set<String> namespaceSet) {
        namespaceSetProperty.updateValue(namespaceSet);
    }

    public static void loadGlobalTransportConfig(ServerTransportConfig config) {
        transportConfigProperty.updateValue(config);
    }

    public static void loadGlobalFlowConfig(ServerFlowConfig config) {
        globalFlowProperty.updateValue(config);
    }

    public static void loadFlowConfig(String namespace, ServerFlowConfig config) {
        AssertUtil.notEmpty(namespace, "namespace cannot be empty");
        globalFlowProperty.updateValue(config);
    }

    public static void addTransportConfigChangeObserver(ServerTransportConfigObserver observer) {
        AssertUtil.notNull(observer, "observer cannot be null");
        TRANSPORT_CONFIG_OBSERVERS.add(observer);
    }

    private static void applyNamespaceSetChange(Set<String> newSet) {
        Set<String> oldSet;
        if (newSet == null) {
            return;
        }
        RecordLog.info("[ClusterServerConfigManager] Server namespace set will be update to: " + newSet, new Object[0]);
        if (newSet.isEmpty()) {
            namespaceSet = Collections.singleton("default");
            return;
        }
        newSet = new HashSet<String>(newSet);
        newSet.add("default");
        if (embedded) {
            newSet.add(ConfigSupplierRegistry.getNamespaceSupplier().get());
        }
        if ((oldSet = namespaceSet) != null && !oldSet.isEmpty()) {
            for (String ns : oldSet) {
                if (newSet.contains(ns)) continue;
                ClusterFlowRuleManager.removeProperty(ns);
                ClusterParamFlowRuleManager.removeProperty(ns);
            }
        }
        namespaceSet = newSet;
        for (String ns : newSet) {
            ClusterFlowRuleManager.registerPropertyIfAbsent(ns);
            ClusterParamFlowRuleManager.registerPropertyIfAbsent(ns);
            GlobalRequestLimiter.initIfAbsent(ns);
        }
    }

    private static void updateTokenServer(ServerTransportConfig config) {
        int newPort = config.getPort();
        AssertUtil.isTrue(newPort > 0, "token server port should be valid (positive)");
        if (newPort == port) {
            return;
        }
        port = newPort;
        for (ServerTransportConfigObserver observer : TRANSPORT_CONFIG_OBSERVERS) {
            observer.onTransportConfigChange(config);
        }
    }

    public static boolean isValidTransportConfig(ServerTransportConfig config) {
        return config != null && config.getPort() > 0 && config.getPort() <= 65535;
    }

    public static boolean isValidFlowConfig(ServerFlowConfig config) {
        return config != null && config.getMaxOccupyRatio() >= 0.0 && config.getExceedCount() >= 0.0 && config.getMaxAllowedQps() >= 0.0 && FlowRuleUtil.isWindowConfigValid(config.getSampleCount(), config.getIntervalMs());
    }

    public static double getExceedCount(String namespace) {
        AssertUtil.notEmpty(namespace, "namespace cannot be empty");
        ServerFlowConfig config = NAMESPACE_CONF.get(namespace);
        if (config != null) {
            return config.getExceedCount();
        }
        return exceedCount;
    }

    public static double getMaxOccupyRatio(String namespace) {
        AssertUtil.notEmpty(namespace, "namespace cannot be empty");
        ServerFlowConfig config = NAMESPACE_CONF.get(namespace);
        if (config != null) {
            return config.getMaxOccupyRatio();
        }
        return maxOccupyRatio;
    }

    public static int getIntervalMs(String namespace) {
        AssertUtil.notEmpty(namespace, "namespace cannot be empty");
        ServerFlowConfig config = NAMESPACE_CONF.get(namespace);
        if (config != null) {
            return config.getIntervalMs();
        }
        return intervalMs;
    }

    public static int getSampleCount(String namespace) {
        AssertUtil.notEmpty(namespace, "namespace cannot be empty");
        ServerFlowConfig config = NAMESPACE_CONF.get(namespace);
        if (config != null) {
            return config.getSampleCount();
        }
        return sampleCount;
    }

    public static double getMaxAllowedQps() {
        return maxAllowedQps;
    }

    public static double getMaxAllowedQps(String namespace) {
        AssertUtil.notEmpty(namespace, "namespace cannot be empty");
        ServerFlowConfig config = NAMESPACE_CONF.get(namespace);
        if (config != null) {
            return config.getMaxAllowedQps();
        }
        return maxAllowedQps;
    }

    public static double getExceedCount() {
        return exceedCount;
    }

    public static double getMaxOccupyRatio() {
        return maxOccupyRatio;
    }

    public static Set<String> getNamespaceSet() {
        return namespaceSet;
    }

    public static int getPort() {
        return port;
    }

    public static int getIdleSeconds() {
        return idleSeconds;
    }

    public static int getIntervalMs() {
        return intervalMs;
    }

    public static int getSampleCount() {
        return sampleCount;
    }

    public static void setNamespaceSet(Set<String> namespaceSet) {
        ClusterServerConfigManager.applyNamespaceSetChange(namespaceSet);
    }

    public static boolean isEmbedded() {
        return embedded;
    }

    public static void setEmbedded(boolean embedded) {
        ClusterServerConfigManager.embedded = embedded;
    }

    public static void setMaxAllowedQps(double maxAllowedQps) {
        ClusterServerConfigManager.maxAllowedQps = maxAllowedQps;
    }

    private ClusterServerConfigManager() {
    }

    static {
        transportConfigProperty.addListener(TRANSPORT_PROPERTY_LISTENER);
        globalFlowProperty.addListener(GLOBAL_FLOW_PROPERTY_LISTENER);
        namespaceSetProperty.addListener(NAMESPACE_SET_PROPERTY_LISTENER);
    }

    private static class ServerGlobalFlowPropertyListener
    implements PropertyListener<ServerFlowConfig> {
        private ServerGlobalFlowPropertyListener() {
        }

        @Override
        public void configUpdate(ServerFlowConfig config) {
            this.applyGlobalFlowConfig(config);
        }

        @Override
        public void configLoad(ServerFlowConfig config) {
            this.applyGlobalFlowConfig(config);
        }

        private synchronized void applyGlobalFlowConfig(ServerFlowConfig config) {
            if (!ClusterServerConfigManager.isValidFlowConfig(config)) {
                RecordLog.warn("[ClusterServerConfigManager] Invalid cluster server global flow config, ignoring: " + config, new Object[0]);
                return;
            }
            RecordLog.info("[ClusterServerConfigManager] Updating new server global flow config: " + config, new Object[0]);
            if (config.getExceedCount() != exceedCount) {
                exceedCount = config.getExceedCount();
            }
            if (config.getMaxOccupyRatio() != maxOccupyRatio) {
                maxOccupyRatio = config.getMaxOccupyRatio();
            }
            if (config.getMaxAllowedQps() != maxAllowedQps) {
                maxAllowedQps = config.getMaxAllowedQps();
                GlobalRequestLimiter.applyMaxQpsChange(maxAllowedQps);
            }
            int newIntervalMs = config.getIntervalMs();
            int newSampleCount = config.getSampleCount();
            if (newIntervalMs != intervalMs || newSampleCount != sampleCount) {
                if (newIntervalMs <= 0 || newSampleCount <= 0 || newIntervalMs % newSampleCount != 0) {
                    RecordLog.warn("[ClusterServerConfigManager] Ignoring invalid flow interval or sample count", new Object[0]);
                } else {
                    intervalMs = newIntervalMs;
                    sampleCount = newSampleCount;
                    ClusterMetricStatistics.resetFlowMetrics();
                    ClusterParamMetricStatistics.resetFlowMetrics();
                }
            }
        }
    }

    private static class ServerGlobalTransportPropertyListener
    implements PropertyListener<ServerTransportConfig> {
        private ServerGlobalTransportPropertyListener() {
        }

        @Override
        public void configLoad(ServerTransportConfig config) {
            if (config == null) {
                RecordLog.warn("[ClusterServerConfigManager] Empty initial server transport config", new Object[0]);
                return;
            }
            this.applyConfig(config);
        }

        @Override
        public void configUpdate(ServerTransportConfig config) {
            this.applyConfig(config);
        }

        private synchronized void applyConfig(ServerTransportConfig config) {
            if (!ClusterServerConfigManager.isValidTransportConfig(config)) {
                RecordLog.warn("[ClusterServerConfigManager] Invalid cluster server transport config, ignoring: " + config, new Object[0]);
                return;
            }
            RecordLog.info("[ClusterServerConfigManager] Updating new server transport config: " + config, new Object[0]);
            if (config.getIdleSeconds() != idleSeconds) {
                idleSeconds = config.getIdleSeconds();
            }
            ClusterServerConfigManager.updateTokenServer(config);
        }
    }

    private static class ServerNamespaceSetPropertyListener
    implements PropertyListener<Set<String>> {
        private ServerNamespaceSetPropertyListener() {
        }

        @Override
        public synchronized void configLoad(Set<String> set) {
            if (set == null || set.isEmpty()) {
                RecordLog.warn("[ClusterServerConfigManager] WARN: empty initial server namespace set", new Object[0]);
                return;
            }
            ClusterServerConfigManager.applyNamespaceSetChange(set);
        }

        @Override
        public synchronized void configUpdate(Set<String> set) {
            ClusterServerConfigManager.applyNamespaceSetChange(set);
        }
    }
}

