/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.server.codec.netty;

import com.alibaba.csp.ahas.shaded.io.netty.buffer.ByteBuf;
import com.alibaba.csp.ahas.shaded.io.netty.channel.ChannelHandlerContext;
import com.alibaba.csp.ahas.shaded.io.netty.handler.codec.MessageToByteEncoder;
import com.alibaba.csp.sentinel.cluster.codec.response.ResponseEntityWriter;
import com.alibaba.csp.sentinel.cluster.response.ClusterResponse;
import com.alibaba.csp.sentinel.cluster.response.Response;
import com.alibaba.csp.sentinel.cluster.server.codec.ServerEntityCodecProvider;
import com.alibaba.csp.sentinel.log.RecordLog;

public class NettyResponseEncoder
extends MessageToByteEncoder<ClusterResponse> {
    @Override
    protected void encode(ChannelHandlerContext ctx, ClusterResponse response, ByteBuf out) throws Exception {
        ResponseEntityWriter responseEntityWriter = ServerEntityCodecProvider.getResponseEntityWriter();
        if (responseEntityWriter == null) {
            RecordLog.warn("[NettyResponseEncoder] Cannot resolve the global response entity writer, reply bad status", new Object[0]);
            this.writeBadStatusHead(response, out);
            return;
        }
        responseEntityWriter.writeTo(response, out);
    }

    private void writeBadStatusHead(Response response, ByteBuf out) {
        out.writeInt(response.getId());
        out.writeByte(-1);
        out.writeByte(response.getStatus());
    }
}

