/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.server.codec.data;

import com.alibaba.csp.ahas.shaded.io.netty.buffer.ByteBuf;
import com.alibaba.csp.sentinel.cluster.codec.EntityDecoder;
import com.alibaba.csp.sentinel.cluster.request.data.ParamFlowRequestData;
import java.util.ArrayList;
import java.util.List;

public class ParamFlowRequestDataDecoder
implements EntityDecoder<ByteBuf, ParamFlowRequestData> {
    @Override
    public ParamFlowRequestData decode(ByteBuf source) {
        if (source.readableBytes() >= 16) {
            ParamFlowRequestData requestData = new ParamFlowRequestData().setFlowId(source.readLong()).setCount(source.readInt());
            int amount = source.readInt();
            if (amount > 0) {
                ArrayList<Object> params = new ArrayList<Object>(amount);
                for (int i = 0; i < amount; ++i) {
                    this.decodeParam(source, params);
                }
                requestData.setParams(params);
                return requestData;
            }
        }
        return null;
    }

    private boolean decodeParam(ByteBuf source, List<Object> params) {
        byte paramType = source.readByte();
        switch (paramType) {
            case 0: {
                params.add(source.readInt());
                return true;
            }
            case 7: {
                int length = source.readInt();
                byte[] bytes = new byte[length];
                source.readBytes(bytes);
                params.add(new String(bytes));
                return true;
            }
            case 6: {
                params.add(source.readBoolean());
                return true;
            }
            case 3: {
                params.add(source.readDouble());
                return true;
            }
            case 1: {
                params.add(source.readLong());
                return true;
            }
            case 4: {
                params.add(Float.valueOf(source.readFloat()));
                return true;
            }
            case 2: {
                params.add(source.readByte());
                return true;
            }
            case 5: {
                params.add(source.readShort());
                return true;
            }
        }
        return false;
    }
}

