/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.server;

import com.alibaba.csp.sentinel.cluster.TokenService;
import com.alibaba.csp.sentinel.cluster.flow.DefaultTokenService;
import com.alibaba.csp.sentinel.log.RecordLog;
import java.util.ArrayList;
import java.util.ServiceLoader;

public final class TokenServiceProvider {
    private static TokenService service = null;
    private static final ServiceLoader<TokenService> LOADER = ServiceLoader.load(TokenService.class);

    public static TokenService getService() {
        return service;
    }

    private static void resolveTokenServiceSpi() {
        boolean hasOther = false;
        ArrayList<TokenService> list = new ArrayList<TokenService>();
        for (TokenService service : LOADER) {
            if (service.getClass() == DefaultTokenService.class) continue;
            hasOther = true;
            list.add(service);
        }
        service = hasOther ? (TokenService)list.get(0) : new DefaultTokenService();
        RecordLog.info("[TokenServiceProvider] Global token service resolved: " + service.getClass().getCanonicalName(), new Object[0]);
    }

    static {
        TokenServiceProvider.resolveTokenServiceSpi();
    }
}

