/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.flow.statistic;

import com.alibaba.csp.sentinel.cluster.flow.statistic.metric.ClusterParamMetric;
import com.alibaba.csp.sentinel.cluster.server.config.ClusterServerConfigManager;
import com.alibaba.csp.sentinel.util.AssertUtil;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class ClusterParamMetricStatistics {
    private static final Map<Long, ClusterParamMetric> METRIC_MAP = new ConcurrentHashMap<Long, ClusterParamMetric>();

    public static void clear() {
        METRIC_MAP.clear();
    }

    public static void putMetric(long id, ClusterParamMetric metric) {
        AssertUtil.notNull(metric, "metric cannot be null");
        METRIC_MAP.put(id, metric);
    }

    public static boolean putMetricIfAbsent(long id, ClusterParamMetric metric) {
        AssertUtil.notNull(metric, "metric cannot be null");
        if (METRIC_MAP.containsKey(id)) {
            return false;
        }
        METRIC_MAP.put(id, metric);
        return true;
    }

    public static void removeMetric(long id) {
        METRIC_MAP.remove(id);
    }

    public static ClusterParamMetric getMetric(long id) {
        return METRIC_MAP.get(id);
    }

    public static void resetFlowMetrics() {
        Set<Long> keySet = METRIC_MAP.keySet();
        for (Long id : keySet) {
            METRIC_MAP.put(id, new ClusterParamMetric(ClusterServerConfigManager.getSampleCount(), ClusterServerConfigManager.getIntervalMs()));
        }
    }

    private ClusterParamMetricStatistics() {
    }
}

