/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.flow;

import com.alibaba.csp.sentinel.cluster.TokenResult;
import com.alibaba.csp.sentinel.cluster.TokenService;
import com.alibaba.csp.sentinel.cluster.flow.ClusterFlowChecker;
import com.alibaba.csp.sentinel.cluster.flow.ClusterParamFlowChecker;
import com.alibaba.csp.sentinel.cluster.flow.rule.ClusterFlowRuleManager;
import com.alibaba.csp.sentinel.cluster.flow.rule.ClusterParamFlowRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import java.util.Collection;

public class DefaultTokenService
implements TokenService {
    @Override
    public TokenResult requestToken(Long ruleId, int acquireCount, boolean prioritized) {
        if (this.notValidRequest(ruleId, acquireCount)) {
            return this.badRequest();
        }
        FlowRule rule = ClusterFlowRuleManager.getFlowRuleById(ruleId);
        if (rule == null) {
            return new TokenResult(3);
        }
        return ClusterFlowChecker.acquireClusterToken(rule, acquireCount, prioritized);
    }

    @Override
    public TokenResult requestParamToken(Long ruleId, int acquireCount, Collection<Object> params) {
        if (this.notValidRequest(ruleId, acquireCount) || params == null || params.isEmpty()) {
            return this.badRequest();
        }
        ParamFlowRule rule = ClusterParamFlowRuleManager.getParamRuleById(ruleId);
        if (rule == null) {
            return new TokenResult(3);
        }
        return ClusterParamFlowChecker.acquireClusterToken(rule, acquireCount, params);
    }

    private boolean notValidRequest(Long id, int count) {
        return id == null || id <= 0L || count <= 0;
    }

    private TokenResult badRequest() {
        return new TokenResult(-4);
    }
}

