/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.client.handler;

import com.alibaba.csp.ahas.shaded.io.netty.channel.ChannelHandlerContext;
import com.alibaba.csp.ahas.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import com.alibaba.csp.sentinel.cluster.client.handler.TokenClientPromiseHolder;
import com.alibaba.csp.sentinel.cluster.registry.ConfigSupplierRegistry;
import com.alibaba.csp.sentinel.cluster.request.ClusterRequest;
import com.alibaba.csp.sentinel.cluster.response.ClusterResponse;
import com.alibaba.csp.sentinel.log.RecordLog;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicInteger;

public class TokenClientHandler
extends ChannelInboundHandlerAdapter {
    private final AtomicInteger currentState;
    private final Runnable disconnectCallback;

    public TokenClientHandler(AtomicInteger currentState, Runnable disconnectCallback) {
        this.currentState = currentState;
        this.disconnectCallback = disconnectCallback;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.currentState.set(2);
        this.fireClientPing(ctx);
        RecordLog.info("[TokenClientHandler] Client handler active, remote address: " + this.getRemoteAddress(ctx), new Object[0]);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ClusterResponse) {
            ClusterResponse response = (ClusterResponse)msg;
            if (response.getType() == 0) {
                this.handlePingResponse(ctx, response);
                return;
            }
            TokenClientPromiseHolder.completePromise(response.getId(), response);
        }
    }

    private void fireClientPing(ChannelHandlerContext ctx) {
        ClusterRequest<String> ping = new ClusterRequest().setId(0).setType(0).setData(ConfigSupplierRegistry.getNamespaceSupplier().get());
        ctx.writeAndFlush(ping);
    }

    private void handlePingResponse(ChannelHandlerContext ctx, ClusterResponse response) {
        if (response.getStatus() == 0) {
            int count = (Integer)response.getData();
            RecordLog.info("[TokenClientHandler] Client ping OK (target server: {0}, connected count: {1})", this.getRemoteAddress(ctx), count);
        } else {
            RecordLog.warn("[TokenClientHandler] Client ping failed (target server: {0})", this.getRemoteAddress(ctx));
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        RecordLog.warn("[TokenClientHandler] Client exception caught", cause);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        RecordLog.info("[TokenClientHandler] Client handler inactive, remote address: " + this.getRemoteAddress(ctx), new Object[0]);
    }

    @Override
    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        RecordLog.info("[TokenClientHandler] Client channel unregistered, remote address: " + this.getRemoteAddress(ctx), new Object[0]);
        this.currentState.set(0);
        this.disconnectCallback.run();
    }

    private String getRemoteAddress(ChannelHandlerContext ctx) {
        if (ctx.channel().remoteAddress() == null) {
            return null;
        }
        InetSocketAddress inetAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        return inetAddress.getAddress().getHostAddress() + ":" + inetAddress.getPort();
    }

    public int getCurrentState() {
        return this.currentState.get();
    }

    public boolean hasStarted() {
        return this.getCurrentState() == 2;
    }
}

