/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.arms;

import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.TBase;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.buffer.ChannelBuffers;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.util.HashedWheelTimer;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.util.Timeout;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.util.Timer;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.util.TimerTask;
import com.alibaba.csp.sentinel.arms.AbstractDataSender;
import com.alibaba.csp.sentinel.arms.AsyncQueueingExecutor;
import com.alibaba.csp.sentinel.arms.EnhancedDataSender;
import com.alibaba.csp.sentinel.arms.RetryMessage;
import com.alibaba.csp.sentinel.arms.RetryQueue;
import com.alibaba.csp.sentinel.arms.WriteFailFutureListener;
import com.navercorp.pinpoint.common.arms.logging.PLogger;
import com.navercorp.pinpoint.common.arms.logging.PLoggerFactory;
import com.navercorp.pinpoint.rpc.Future;
import com.navercorp.pinpoint.rpc.FutureListener;
import com.navercorp.pinpoint.rpc.ResponseMessage;
import com.navercorp.pinpoint.rpc.client.PinpointClient;
import com.navercorp.pinpoint.rpc.client.PinpointClientFactory;
import com.navercorp.pinpoint.rpc.util.ClientFactoryUtils;
import com.navercorp.pinpoint.rpc.util.TimerFactory;
import com.navercorp.pinpoint.thrift.dto.TResult;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseDeserializer;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseDeserializerFactory;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseSerializer;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseSerializerFactory;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class TcpDataSender
extends AbstractDataSender
implements EnhancedDataSender {
    private final PLogger logger;
    private final PinpointClient client;
    private final Timer timer;
    private final AtomicBoolean fireState = new AtomicBoolean(false);
    private final WriteFailFutureListener writeFailFutureListener;
    private final RetryQueue retryQueue = new RetryQueue();
    private final HeaderTBaseSerializer serializer;
    private AsyncQueueingExecutor<Object> executor;

    public TcpDataSender(String name, String host, int port, PinpointClientFactory clientFactory) {
        this(name, host, port, clientFactory, HeaderTBaseSerializerFactory.DEFAULT_FACTORY.createSerializer());
    }

    public TcpDataSender(String name, String host, int port, PinpointClientFactory clientFactory, HeaderTBaseSerializer serializer) {
        PinpointClient client;
        if (host == null) {
            throw new NullPointerException("host must not be null");
        }
        if (clientFactory == null) {
            throw new NullPointerException("clientFactory must not be null");
        }
        if (serializer == null) {
            throw new NullPointerException("serializer must not be null");
        }
        String executorName = "Pinpoint-TcpDataSender-Executor";
        if (name != null) {
            this.logger = PLoggerFactory.getLogger(this.getClass().getName() + "@" + name);
            executorName = String.format("Pinpoint-TcpDataSender(%s)-Executor", name);
        } else {
            this.logger = PLoggerFactory.getLogger(this.getClass());
        }
        this.client = client = ClientFactoryUtils.createPinpointClient(host, port, clientFactory);
        this.serializer = serializer;
        this.timer = this.createTimer(name);
        this.writeFailFutureListener = new WriteFailFutureListener(this.logger, "io write fail.", "host", -1);
        this.executor = this.createAsyncQueueingExecutor(5120, executorName);
    }

    private Timer createTimer(String name) {
        String timerName = "Pinpoint-TcpDataSender-Timer";
        if (name != null) {
            timerName = String.format("Pinpoint-TcpDataSender(%s)-Timer", name);
        }
        HashedWheelTimer timer = TimerFactory.createHashedWheelTimer(timerName, 100L, TimeUnit.MILLISECONDS, 512);
        timer.start();
        return timer;
    }

    @Override
    public boolean send(TBase<?, ?> data) {
        return this.executor.execute(data);
    }

    @Override
    public boolean request(TBase<?, ?> data) {
        return this.request(data, 3);
    }

    @Override
    public boolean request(TBase<?, ?> data, int retryCount) {
        AbstractDataSender.RequestMarker message = new AbstractDataSender.RequestMarker(data, retryCount);
        return this.executor.execute(message);
    }

    @Override
    public boolean request(TBase<?, ?> data, FutureListener<ResponseMessage> listener) {
        AbstractDataSender.RequestMarker message = new AbstractDataSender.RequestMarker(data, listener);
        return this.executor.execute(message);
    }

    @Override
    public void stop() {
        this.executor.stop();
        Set<Timeout> stop = this.timer.stop();
        if (!stop.isEmpty()) {
            this.logger.info("stop Timeout:{}", (Object)stop.size());
        }
        if (this.client != null) {
            this.client.close();
        }
    }

    @Override
    protected void sendPacket(Object message) {
        block8: {
            try {
                if (message instanceof TBase) {
                    byte[] copy = this.serialize(this.serializer, (TBase)message);
                    if (copy == null) {
                        return;
                    }
                    this.doSend(copy);
                    break block8;
                }
                if (message instanceof AbstractDataSender.RequestMarker) {
                    AbstractDataSender.RequestMarker requestMarker = (AbstractDataSender.RequestMarker)message;
                    TBase tBase = requestMarker.getTBase();
                    int retryCount = requestMarker.getRetryCount();
                    FutureListener futureListener = requestMarker.getFutureListener();
                    byte[] copy = this.serialize(this.serializer, tBase);
                    if (copy == null) {
                        return;
                    }
                    if (futureListener != null) {
                        this.doRequest(copy, futureListener);
                    } else {
                        this.doRequest(copy, retryCount, tBase);
                    }
                    break block8;
                }
                this.logger.error("sendPacket fail. invalid dto type:{}", (Object)message.getClass());
                return;
            }
            catch (Exception e) {
                this.logger.warn("tcp send fail. Caused:{}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private void doSend(byte[] copy) {
        Future write = this.client.sendAsync(copy);
        write.setListener(this.writeFailFutureListener);
    }

    private void doRequest(final byte[] requestPacket, final int maxRetryCount, final Object targetClass) {
        FutureListener<ResponseMessage> futureListener = new FutureListener<ResponseMessage>(){

            @Override
            public void onComplete(Future<ResponseMessage> future) {
                if (future.isSuccess()) {
                    HeaderTBaseDeserializer deserializer = HeaderTBaseDeserializerFactory.DEFAULT_FACTORY.createDeserializer();
                    TBase<?, ?> response = TcpDataSender.this.deserialize(deserializer, future.getResult());
                    if (response instanceof TResult) {
                        TResult result = (TResult)response;
                        if (result.isSuccess()) {
                            TcpDataSender.this.logger.debug("result success");
                        } else {
                            TcpDataSender.this.logger.info("request fail. request:{} Caused:{}", targetClass, (Object)result.getMessage());
                            RetryMessage retryMessage = new RetryMessage(1, maxRetryCount, requestPacket, targetClass.getClass().getSimpleName());
                            TcpDataSender.this.retryRequest(retryMessage);
                        }
                    } else {
                        TcpDataSender.this.logger.warn("Invalid respose:{}", (Object)response);
                    }
                } else {
                    TcpDataSender.this.logger.info("request fail. request:{} Caused:{}", targetClass, future.getCause().getMessage(), future.getCause());
                    RetryMessage retryMessage = new RetryMessage(1, maxRetryCount, requestPacket, targetClass.getClass().getSimpleName());
                    TcpDataSender.this.retryRequest(retryMessage);
                }
            }
        };
        this.doRequest(requestPacket, futureListener);
    }

    private void doRequest(final RetryMessage retryMessage) {
        FutureListener<ResponseMessage> futureListener = new FutureListener<ResponseMessage>(){

            @Override
            public void onComplete(Future<ResponseMessage> future) {
                if (future.isSuccess()) {
                    HeaderTBaseDeserializer deserializer = HeaderTBaseDeserializerFactory.DEFAULT_FACTORY.createDeserializer();
                    TBase<?, ?> response = TcpDataSender.this.deserialize(deserializer, future.getResult());
                    if (response instanceof TResult) {
                        TResult result = (TResult)response;
                        if (result.isSuccess()) {
                            TcpDataSender.this.logger.debug("result success");
                        } else {
                            TcpDataSender.this.logger.info("request fail. request:{}, Caused:{}", (Object)retryMessage, (Object)result.getMessage());
                            TcpDataSender.this.retryRequest(retryMessage);
                        }
                    } else {
                        TcpDataSender.this.logger.warn("Invalid response:{}", (Object)response);
                    }
                } else {
                    TcpDataSender.this.logger.info("request fail. request:{}, caused:{}", retryMessage, future.getCause().getMessage(), future.getCause());
                    TcpDataSender.this.retryRequest(retryMessage);
                }
            }
        };
        this.doRequest(retryMessage.getBytes(), futureListener);
    }

    private void retryRequest(RetryMessage retryMessage) {
        this.retryQueue.add(retryMessage);
        if (this.fireTimeout()) {
            this.timer.newTimeout(new TimerTask(){

                @Override
                public void run(Timeout timeout) throws Exception {
                    while (true) {
                        RetryMessage retryMessage;
                        if ((retryMessage = TcpDataSender.this.retryQueue.get()) == null) {
                            TcpDataSender.this.fireComplete();
                            return;
                        }
                        int fail = retryMessage.fail();
                        TcpDataSender.this.doRequest(retryMessage);
                    }
                }
            }, 10000L, TimeUnit.MILLISECONDS);
        }
    }

    private void doRequest(byte[] requestPacket, FutureListener futureListener) {
        Future<ResponseMessage> response = this.client.request(requestPacket);
        response.setListener(futureListener);
    }

    private boolean fireTimeout() {
        return this.fireState.compareAndSet(false, true);
    }

    private void fireComplete() {
        this.logger.debug("fireComplete");
        this.fireState.compareAndSet(true, false);
    }

    static {
        ChannelBuffers.buffer(2);
    }
}

