/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.arms;

import com.alibaba.csp.sentinel.arms.RetryMessage;
import com.navercorp.pinpoint.common.arms.logging.PLogger;
import com.navercorp.pinpoint.common.arms.logging.PLoggerFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class RetryQueue {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final BlockingQueue<RetryMessage> queue = new LinkedBlockingQueue<RetryMessage>();
    private final int capacity;
    private final int maxRetryCount;
    private final int halfCapacity;

    public RetryQueue(int capacity, int maxRetryCount) {
        this.capacity = capacity;
        this.halfCapacity = capacity / 2;
        this.maxRetryCount = maxRetryCount;
    }

    public RetryQueue() {
        this(1024, 3);
    }

    public void add(RetryMessage retryMessage) {
        if (retryMessage == null) {
            throw new NullPointerException("retryMessage must not be null");
        }
        if (!retryMessage.isRetryAvailable()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("discard retry message({}).", (Object)retryMessage);
            }
            return;
        }
        int retryCount = retryMessage.getRetryCount();
        if (retryCount >= this.maxRetryCount) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("discard retry message({}). queue-maxRetryCount:{}", (Object)retryMessage, (Object)this.maxRetryCount);
            }
            return;
        }
        int queueSize = this.queue.size();
        if (queueSize >= this.capacity) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("discard retry message. queueSize:{}", (Object)queueSize);
            }
            return;
        }
        if (queueSize >= this.halfCapacity && retryCount >= 1) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("discard retry message. retryCount:{}", (Object)retryCount);
            }
            return;
        }
        boolean offer = this.queue.offer(retryMessage);
        if (!offer) {
            this.logger.warn("offer() fail. discard retry message. retryCount:{}", (Object)retryCount);
        }
    }

    public RetryMessage get() {
        return (RetryMessage)this.queue.poll();
    }

    public int size() {
        return this.queue.size();
    }
}

