/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.arms;

import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.TBase;
import com.alibaba.csp.sentinel.arms.ArmsCallbackContext;
import com.navercorp.pinpoint.common.arms.logging.PLogger;
import com.navercorp.pinpoint.common.arms.logging.PLoggerFactory;
import com.navercorp.pinpoint.rpc.Future;
import com.navercorp.pinpoint.rpc.FutureListener;
import com.navercorp.pinpoint.rpc.ResponseMessage;
import com.navercorp.pinpoint.thrift.dto.TResult;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseDeserializerFactory;
import com.navercorp.pinpoint.thrift.util.SerializationUtils;

public class AgentInfoSenderListener
implements FutureListener<ResponseMessage> {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());

    @Override
    public void onComplete(Future<ResponseMessage> future) {
        try {
            if (future != null && future.isSuccess()) {
                TBase<?, ?> tbase = this.deserialize(future);
                if (tbase instanceof TResult) {
                    TResult result = (TResult)tbase;
                    if (result.isSuccess()) {
                        String msg = result.getMessage();
                        if (msg != null) {
                            ArmsCallbackContext.setAgentId(msg);
                            this.logger.info("agent id: " + ArmsCallbackContext.getAgentId());
                        }
                        return;
                    }
                    this.logger.error("Server check failed.  " + result.getMessage());
                    System.err.println("Server check failed.  " + result.getMessage());
                } else {
                    this.logger.warn("Invalid Class. {}", (Object)tbase);
                }
            }
        }
        catch (Exception e) {
            this.logger.warn("request fail. caused:{}", (Object)e.getMessage());
        }
    }

    private TBase<?, ?> deserialize(Future<ResponseMessage> future) {
        ResponseMessage responseMessage = future.getResult();
        byte[] message = responseMessage.getMessage();
        return SerializationUtils.deserialize(message, HeaderTBaseDeserializerFactory.DEFAULT_FACTORY, null);
    }
}

