/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.gateway.common.command;

import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSONArray;
import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayFlowRule;
import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayRuleManager;
import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.command.annotation.CommandMapping;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.List;

@CommandMapping(name="gateway/updateRules", desc="Update gateway rules")
public class UpdateGatewayRuleCommandHandler
implements CommandHandler<String> {
    private static final String SUCCESS_MSG = "success";

    @Override
    public CommandResponse<String> handle(CommandRequest request) {
        String data = request.getParam("data");
        if (StringUtil.isBlank(data)) {
            return CommandResponse.ofFailure(new IllegalArgumentException("Bad data"));
        }
        try {
            data = URLDecoder.decode(data, "utf-8");
        }
        catch (Exception e) {
            RecordLog.info("Decode gateway rule data error", e);
            return CommandResponse.ofFailure(e, "decode gateway rule data error");
        }
        RecordLog.info(String.format("[API Server] Receiving rule change (type: gateway rule): %s", data), new Object[0]);
        String result = SUCCESS_MSG;
        List<GatewayFlowRule> flowRules = JSONArray.parseArray(data, GatewayFlowRule.class);
        GatewayRuleManager.loadRules(new HashSet<GatewayFlowRule>(flowRules));
        return CommandResponse.ofSuccess(result);
    }
}

