/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.diamond.client.impl;

import com.alibaba.csp.ahas.shaded.com.taobao.diamond.client.impl.DiamondEnv;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class EventDispatcher {
    static final Map<Class<? extends Event>, CopyOnWriteArrayList<EventListener>> listenerMap = new HashMap<Class<? extends Event>, CopyOnWriteArrayList<EventListener>>();

    public static void addEventListener(EventListener listener) {
        for (Class<? extends Event> type : listener.interest()) {
            EventDispatcher.getListenerList(type).addIfAbsent(listener);
        }
    }

    public static void fireEvent(Event event) {
        if (null == event) {
            return;
        }
        for (Event implyEvent : event.implyEvents()) {
            try {
                if (event == implyEvent) continue;
                EventDispatcher.fireEvent(implyEvent);
            }
            catch (Exception e) {
                DiamondEnv.log.warn("", e.toString(), e);
            }
        }
        for (EventListener listener : EventDispatcher.getListenerList(event.getClass())) {
            try {
                listener.onEvent(event);
            }
            catch (Exception e) {
                DiamondEnv.log.warn(e.toString(), e);
            }
        }
    }

    static synchronized CopyOnWriteArrayList<EventListener> getListenerList(Class<? extends Event> eventType) {
        CopyOnWriteArrayList<EventListener> listeners = listenerMap.get(eventType);
        if (null == listeners) {
            listeners = new CopyOnWriteArrayList();
            listenerMap.put(eventType, listeners);
        }
        return listeners;
    }

    public static class ServerlistChangeEvent
    extends Event {
    }

    public static abstract class EventListener {
        public EventListener() {
            EventDispatcher.addEventListener(this);
        }

        public abstract List<Class<? extends Event>> interest();

        public abstract void onEvent(Event var1);
    }

    public static abstract class Event {
        protected List<Event> implyEvents() {
            return Collections.EMPTY_LIST;
        }
    }
}

