/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.diamond.client.impl;

import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.alibaba.metrics.Gauge;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.client.impl.DiamondEnv;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.client.impl.ServerListManager;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.client.impl.ServerManager_unitSite;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.maintenance.DiamondMetric;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DiamondEnvRepo {
    @Deprecated
    public static DiamondEnv defaultEnv = DiamondEnvRepo.getDefaultEnv();
    private static final Map<String, DiamondEnv> diamondEnvs = new HashMap<String, DiamondEnv>();

    public static synchronized List<DiamondEnv> allDiamondEnvs() {
        ArrayList<DiamondEnv> envs = new ArrayList<DiamondEnv>(diamondEnvs.values());
        envs.add(DiamondEnvRepo.getDefaultEnv());
        return envs;
    }

    public static synchronized DiamondEnv getTargetEnv(String host, int port) {
        try {
            InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
        String name = String.format("%s-%d", host, port);
        DiamondEnv env = diamondEnvs.get(name);
        if (null != env) {
            return env;
        }
        env = new DiamondEnv(new ServerListManager(host, port));
        diamondEnvs.put(name, env);
        return env;
    }

    public static synchronized DiamondEnv getTargetEnv(String ... serverIps) {
        for (int i = 0; i < serverIps.length; ++i) {
            serverIps[i] = serverIps[i].trim();
            String ip = serverIps[i];
            try {
                InetAddress.getByName(ip);
                continue;
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        String name = DiamondEnvRepo.getWorkerName(serverIps);
        DiamondEnv env = diamondEnvs.get(name);
        if (null == env) {
            env = new DiamondEnv(serverIps);
            diamondEnvs.put(name, env);
        }
        return env;
    }

    protected static synchronized DiamondEnv getUnitEnv(String unitName) {
        DiamondEnv env = diamondEnvs.get(unitName);
        if (null != env) {
            return env;
        }
        env = new DiamondEnv(new ServerManager_unitSite(unitName));
        diamondEnvs.put(unitName, env);
        return env;
    }

    protected static String getWorkerName(String ... serverIps) {
        StringBuilder sb = new StringBuilder("com.alibaba.csp.ahas.shaded.com.taobao.diamond.client.worker-");
        String split = "";
        for (String serverIp : serverIps) {
            sb.append(split);
            sb.append(serverIp);
            split = "-";
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DiamondEnv getDefaultEnv() {
        if (defaultEnv != null) return defaultEnv;
        Class<DiamondEnv> clazz = DiamondEnv.class;
        synchronized (DiamondEnv.class) {
            if (defaultEnv != null) return defaultEnv;
            defaultEnv = new DiamondEnv(new ServerListManager());
            Gauge<Integer> defaultEnvListenerSizeGauge = new Gauge<Integer>(){

                @Override
                public long lastUpdateTime() {
                    return System.currentTimeMillis();
                }

                @Override
                public Integer getValue() {
                    return defaultEnv.getAllListeners().size();
                }
            };
            DiamondMetric.getMetricRegistry().register("middleware.diamond.defaultEnv.listenerSize", defaultEnvListenerSizeGauge);
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultEnv;
        }
    }

    public static synchronized void setDefaultDiamond(DiamondEnv diamondEnv) {
        if (defaultEnv == null) {
            defaultEnv = diamondEnv;
        } else {
            defaultEnv.initServerManager(diamondEnv.serverMgr);
        }
    }

    static {
        Gauge<Integer> envSizeGauge = new Gauge<Integer>(){

            @Override
            public long lastUpdateTime() {
                return 0L;
            }

            @Override
            public Integer getValue() {
                return diamondEnvs.size() + 1;
            }
        };
        DiamondMetric.getMetricRegistry().register("middleware.diamond.envSize", envSizeGauge);
    }
}

