/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.transport.api;

import java.util.HashMap;
import java.util.Map;

public class Request {
    private static final String FROM_HEADER = "FR";
    private static final String CLIENT = "C";
    private static final String SERVER = "S";
    protected final Map<String, String> headers = new HashMap<String, String>();
    protected final Map<String, String> params = new HashMap<String, String>();

    public Request() {
        this(false);
    }

    public Request(boolean isClient) {
        if (isClient) {
            this.headers.put(FROM_HEADER, CLIENT);
        } else {
            this.headers.put(FROM_HEADER, SERVER);
        }
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public String getHeader(String key) {
        return this.headers.get(key);
    }

    public String getParam(String key) {
        return this.params.get(key);
    }

    public void removeHeader(String key) {
        this.headers.remove(key);
    }

    public void removeParam(String key) {
        this.params.remove(key);
    }

    public boolean fromClient() {
        return CLIENT.equals(this.getHeader(FROM_HEADER));
    }

    public boolean fromServer() {
        return SERVER.equals(this.getHeader(FROM_HEADER));
    }

    public Request addHeader(String key, String value) {
        if (this.isBlank(key)) {
            throw new IllegalArgumentException("Parameter key cannot be empty");
        }
        this.headers.put(key, value);
        return this;
    }

    public Request addParam(String key, String value) {
        if (this.isBlank(key)) {
            throw new IllegalArgumentException("Parameter key cannot be empty");
        }
        this.params.put(key, value);
        return this;
    }

    private boolean isBlank(String value) {
        return value == null || value.trim().length() == 0;
    }
}

