/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.config;

import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.api.config.ConfigService;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.exception.AhasClientException;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.service.util.ConfigFileHelper;
import java.util.Map;
import java.util.Properties;

public class DefaultConfigService
implements ConfigService {
    public static final String UNKNOWN = "unknown";
    private Properties configs = new Properties();

    public ConfigService init(String param, ClassLoader classLoader) throws AhasClientException {
        Properties properties = ConfigFileHelper.loadVersionProperties(classLoader);
        if (properties != null) {
            this.configs.putAll((Map<?, ?>)properties);
        }
        if ((properties = ConfigFileHelper.loadConfigFile(classLoader)) != null) {
            this.configs.putAll((Map<?, ?>)properties);
        }
        return this;
    }

    @Override
    public String getLicense() {
        return this.getProperty("ahas.license");
    }

    @Override
    public boolean isPrivate() {
        String scope = this.getProperty("ahas.scope");
        return "private".equalsIgnoreCase(scope);
    }

    @Override
    public String getVersion() {
        return this.getProperty("ahas.version", UNKNOWN);
    }

    @Override
    public String getBuildNumber() {
        return this.getProperty("ahas.build.number", UNKNOWN);
    }

    @Override
    public void setIsPrivate(boolean isPrivate) {
        if (isPrivate) {
            System.setProperty("ahas.scope", "private");
        } else {
            System.setProperty("ahas.scope", "public");
        }
    }

    @Override
    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value = this.getPropertyFromSystemProperties(key);
        if (value != null) {
            return value;
        }
        value = this.getPropertyFromSystemEnvironment(key);
        if (value != null) {
            return value;
        }
        return this.configs.getProperty(key, defaultValue);
    }

    protected String getPropertyFromSystemProperties(String key) {
        return System.getProperty(key);
    }

    protected String getPropertyFromSystemEnvironment(String key) {
        return System.getenv(key);
    }
}

