/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.status;

import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSON;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Compass;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Counter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricLevel;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricManager;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.StringUtils;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.AbstractFileBackend;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.ChannelFileBackend;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.DataSource;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.IndexData;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.IndexFile;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.status.LogDescriptionRegister;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.utils.FigureUtil;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.utils.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogDescriptionManager {
    private static final Logger logger = LoggerFactory.getLogger(LogDescriptionManager.class);
    private static String path;
    private Map<Long, LogDescriptionRegister> descriptions = new ConcurrentHashMap<Long, LogDescriptionRegister>();
    private Counter metaTimeout = MetricManager.getCounter("situation_awareness", new MetricName("middleware.metrics.cache.meta_timeout"));
    private Counter metaAccess = MetricManager.getCounter("situation_awareness", new MetricName("middleware.metrics.cache.meta_access"));
    private Compass metaLoad = MetricManager.getCompass("self-statistics", new MetricName("middleware.metrics.cache.meta_load"));
    private Map<MetricLevel, Long> lastCollectionTime = new HashMap<MetricLevel, Long>(){
        {
            long currentTime = System.currentTimeMillis();
            this.put(MetricLevel.CRITICAL, currentTime);
            this.put(MetricLevel.MAJOR, currentTime);
            this.put(MetricLevel.MINOR, currentTime);
            this.put(MetricLevel.NORMAL, currentTime);
            this.put(MetricLevel.TRIVIAL, currentTime);
        }
    };
    private int cacheTime = 60000;
    private final ScheduledExecutorService executor;
    private Runnable task = new Runnable(){

        @Override
        public void run() {
            try {
                long currentTimestamp = System.currentTimeMillis();
                long checkTimestamp = FigureUtil.getTodayStartTimestamp(currentTimestamp);
                for (Long describeTime : LogDescriptionManager.this.descriptions.keySet()) {
                    long visitTime;
                    if (describeTime == checkTimestamp || (visitTime = ((LogDescriptionRegister)LogDescriptionManager.this.descriptions.get(describeTime)).getVisitTime()) + (long)LogDescriptionManager.this.cacheTime >= currentTimestamp) continue;
                    LogDescriptionManager.this.descriptions.remove(describeTime);
                    LogDescriptionManager.this.metaTimeout.inc();
                    logger.debug("remove from descriptions, key is {}", (Object)checkTimestamp);
                }
            }
            catch (Exception e) {
                logger.error("LogDescriptionManager error", e);
            }
        }
    };

    public LogDescriptionManager(String path) {
        this.executor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("LogDescriptionManager"));
        LogDescriptionManager.path = path;
    }

    public void start(long delay, int cacheTime, TimeUnit unit) {
        this.cacheTime = (int)unit.toMillis(cacheTime);
        this.executor.scheduleWithFixedDelay(this.task, delay, this.cacheTime, TimeUnit.MILLISECONDS);
    }

    public LogDescriptionRegister getLogDescriptions(long baseTimestamp) {
        LogDescriptionRegister register = this.descriptions.get(baseTimestamp);
        this.metaAccess.inc();
        if (register == null) {
            register = this.readRegister(baseTimestamp);
        }
        register.setVisitTime(System.currentTimeMillis());
        return register;
    }

    public void setLogDescriptions(long baseTimestamp, LogDescriptionRegister register) {
        register.setVisitTime(System.currentTimeMillis());
        this.descriptions.put(baseTimestamp, register);
    }

    public long getLastCollectionTime(MetricLevel level) {
        return this.lastCollectionTime.get((Object)level);
    }

    public void setLastCollectionTime(MetricLevel level, long lastCollectionTime) {
        this.lastCollectionTime.put(level, lastCollectionTime);
    }

    public LogDescriptionRegister readDataSourceFile(LogDescriptionRegister register, String dataSourceFileName) throws IOException {
        File file = new File(dataSourceFileName);
        if (!file.exists()) {
            return register;
        }
        ChannelFileBackend backend = new ChannelFileBackend(dataSourceFileName, true);
        byte[] dataSourceBytes = backend.readAll();
        try {
            dataSourceBytes = backend.readAll();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (backend != null) {
                ((AbstractFileBackend)backend).close();
            }
        }
        String[] dataSources = new String(dataSourceBytes).split("\n");
        if (dataSources == null || dataSources.length == 0) {
            return register;
        }
        int currentOffset = 0;
        int currentOrder = 0;
        int maxOffset = 0;
        int maxOrder = 0;
        int dataSourceNum = 0;
        for (String s : dataSources) {
            try {
                if (StringUtils.isBlank(s)) continue;
                DataSource dataSource = null;
                try {
                    dataSource = JSON.parseObject(s, DataSource.class);
                }
                catch (Exception e) {
                    logger.error("Error datasource json {} !", (Object)s, (Object)e);
                }
                if (dataSource == null) continue;
                dataSource.addMetricObject();
                if (dataSource.getOrder() > maxOrder) {
                    maxOrder = dataSource.getOrder();
                }
                if (dataSource.getOffset() >= maxOffset) {
                    maxOffset = dataSource.getOffset();
                }
                ++dataSourceNum;
                register.addDataSources(dataSource.getMetricObject(), dataSource);
            }
            catch (Exception e) {
                logger.error("Error file path {}, !", (Object)dataSourceFileName, (Object)e);
            }
        }
        if (dataSourceNum > 0) {
            currentOffset = maxOffset + 8;
            currentOrder = maxOrder + 1;
        }
        register.setCurrentOffset(currentOffset);
        register.setCurrentOrder(currentOrder);
        return register;
    }

    public void clear() {
        this.descriptions.clear();
    }

    private synchronized LogDescriptionRegister readRegister(long baseTimestamp) {
        LogDescriptionRegister register = this.descriptions.get(baseTimestamp);
        if (register != null) {
            return register;
        }
        register = new LogDescriptionRegister();
        long readDiskStart = System.currentTimeMillis();
        register = new LogDescriptionRegister();
        for (MetricLevel level : MetricLevel.values()) {
            String dataSourceFileName = FileUtil.getDataSourceFileName(baseTimestamp, path, level);
            String indexFileName = FileUtil.getIndexFileName(baseTimestamp, path, level);
            try {
                this.readDataSourceFile(register, dataSourceFileName);
            }
            catch (IOException e) {
                logger.error("Read file {} fail!", (Object)dataSourceFileName);
                break;
            }
        }
        long readDiskEnd = System.currentTimeMillis();
        this.setLogDescriptions(baseTimestamp, register);
        this.metaLoad.time().success();
        this.metaLoad.update(readDiskEnd - readDiskStart, TimeUnit.MILLISECONDS);
        return register;
    }

    public int getSize() {
        return this.descriptions.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, IndexData> getIndexFromDisk(long diskStartTime, long diskEndTime, long baseTimestamp, MetricLevel level) {
        Map<Long, IndexData> result = null;
        String indexFileName = FileUtil.getIndexFileName(baseTimestamp, path, level);
        IndexFile indexFile = new IndexFile(indexFileName, level);
        try {
            indexFile.init(true);
        }
        catch (Exception e) {
            logger.error("Init indexFile {} error when searching!", (Object)indexFileName);
            return result;
        }
        try {
            result = indexFile.read(diskStartTime, diskEndTime);
        }
        catch (Throwable e) {
            logger.error("Read indexfile error!", e);
        }
        finally {
            try {
                indexFile.close();
            }
            catch (IOException e) {
                logger.error("Close indexFile {} failed!", (Object)indexFileName);
            }
        }
        return result;
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        private NamedThreadFactory(String name) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "metrics-" + name + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(true);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

