/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.server;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricLevel;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.bean.MetricResult;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.AbstractFileBackend;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.ChannelFileBackend;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.DataSource;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.IndexData;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.LongDZBP;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.server.MetricsDataStore;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.utils.FileUtil;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsOnDisk
extends MetricsDataStore {
    private static final Logger logger = LoggerFactory.getLogger(MetricsOnDisk.class);
    private static String dataPath;

    public MetricsOnDisk(String dataPath) {
        MetricsOnDisk.dataPath = dataPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<MetricLevel, SortedMap<Long, List<MetricResult>>> getDataFromDisk(int precision, MetricLevel level, Set<DataSource> dataSources, Map<Long, IndexData> indexs, Map<MetricLevel, SortedMap<Long, List<MetricResult>>> results) {
        SortedMap<Long, List<MetricResult>> result = results.get((Object)level);
        if (result == null) {
            result = new TreeMap<Long, List<MetricResult>>();
            results.put(level, result);
        }
        boolean dataBlockExceeded = false;
        for (Map.Entry<Long, IndexData> indexEntry : indexs.entrySet()) {
            long timestamp = indexEntry.getKey();
            long indexStart = indexEntry.getValue().getIndexStart();
            long indexEnd = indexEntry.getValue().getIndexEnd();
            List<MetricResult> currentResult = (List<MetricResult>)result.get(timestamp);
            int length = (int)(indexEnd - indexStart);
            if (length > 0x100000) {
                dataBlockExceeded = true;
                continue;
            }
            byte[] b = new byte[length];
            AbstractFileBackend backend = this.getFileBackend(timestamp, level);
            try {
                backend.read(indexStart, b);
            }
            catch (IOException e) {
                logger.error("Read file error!", e);
            }
            finally {
                if (backend != null) {
                    try {
                        backend.close();
                    }
                    catch (IOException e) {
                        logger.error("Close file error!", e);
                    }
                }
            }
            long[] dataArray = null;
            try {
                dataArray = LongDZBP.fromBytes(b);
            }
            catch (Exception e) {
                logger.error("LongDZBP data error!");
                continue;
            }
            currentResult = this.createMetricsResult(dataSources, dataArray, timestamp, level, precision, currentResult);
            result.put(timestamp, currentResult);
        }
        if (dataBlockExceeded) {
            logger.warn("Data block exceeded!");
        }
        results.put(level, result);
        return results;
    }

    private AbstractFileBackend getFileBackend(long timestamp, MetricLevel level) {
        String filePath = FileUtil.getLogFileName(timestamp, dataPath, level);
        ChannelFileBackend backend = null;
        try {
            backend = new ChannelFileBackend(filePath, true);
        }
        catch (IOException e) {
            logger.error("Open file error {}", (Object)filePath);
        }
        return backend;
    }
}

