/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.server;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricLevel;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.bean.MetricResult;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.bean.ValueStatus;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.config.MetricsCollectPeriodConfig;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.DataSource;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.utils.FigureUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class MetricsDataStore {
    private MetricsCollectPeriodConfig metricsCollectPeriodConfig = new MetricsCollectPeriodConfig();

    List<MetricResult> createMetricsResult(Set<DataSource> dataSources, long[] dataArray, long timestamp, MetricLevel level, int precision, List<MetricResult> resultList) {
        for (DataSource dataSource : dataSources) {
            ValueStatus valueStatus;
            long addTime = dataSource.getAddTime();
            if (timestamp < addTime) continue;
            if (resultList == null) {
                resultList = new LinkedList<MetricResult>();
            }
            MetricResult metricResult = new MetricResult(dataSource.getMetricName(), dataSource.getTags(), ValueStatus.NAN, null, timestamp, this.metricsCollectPeriodConfig.period(level), dataSource.getMetricType(), dataSource.getMeterName());
            if (this.metricsCollectPeriodConfig.period(dataSource.getLevel()) > precision) {
                metricResult.setValueStatus(ValueStatus.INVALID_PRECISION);
                resultList.add(metricResult);
                continue;
            }
            int offset = dataSource.getOffset();
            if (offset > dataArray.length * 8) continue;
            int order = dataSource.getOrder();
            long value = dataArray[order];
            int fieldType = dataSource.getFieldType();
            Object o = FigureUtil.getValueByType(fieldType, value);
            if (value == -10001L) {
                valueStatus = ValueStatus.NAN;
                o = 0;
            } else {
                valueStatus = ValueStatus.EXIST;
            }
            metricResult.setValue(o);
            metricResult.setValueStatus(valueStatus);
            resultList.add(metricResult);
        }
        return resultList;
    }
}

