/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.filters;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.encodings.LongEncoder;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.filters.LongFilter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.filters.LongFilterFactory;

public class LongEncodingFilter
implements LongFilter {
    private final LongEncoder encoder;
    private long savedContext = 0L;

    public LongEncodingFilter(LongEncoder encoder) {
        this.encoder = encoder;
    }

    @Override
    public long filterLong(long value) {
        return this.encoder.encodeLong(value);
    }

    @Override
    public void saveContext() {
        this.savedContext = this.encoder.getContextValue();
    }

    @Override
    public void restoreContext() {
        this.encoder.setContextValue(this.savedContext);
    }

    @Override
    public void resetContext() {
        this.savedContext = 0L;
    }

    public static class Factory
    implements LongFilterFactory {
        private final LongEncoder encoder;

        public Factory(LongEncoder encoder) {
            this.encoder = encoder;
        }

        @Override
        public LongFilter newFilter(long firstValue) {
            LongEncoder e = this.getLongEncoder(firstValue);
            return new LongEncodingFilter(e);
        }

        private LongEncoder getLongEncoder(long firstValue) {
            this.encoder.setContextValue(firstValue);
            return this.encoder;
        }
    }
}

