/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.filters;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.encodings.IntEncoder;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.filters.IntFilter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.filters.IntFilterFactory;

public class IntEncodingFilter
implements IntFilter {
    private final IntEncoder encoder;
    private int savedContext = 0;

    IntEncodingFilter(IntEncoder encoder) {
        this.encoder = encoder;
    }

    @Override
    public int filterInt(int value) {
        return this.encoder.encodeInt(value);
    }

    @Override
    public void saveContext() {
        this.savedContext = this.encoder.getContextValue();
    }

    @Override
    public void restoreContext() {
        this.encoder.setContextValue(this.savedContext);
    }

    @Override
    public void resetContext() {
        this.savedContext = 0;
    }

    public static class Factory
    implements IntFilterFactory {
        private final IntEncoder encoder;

        public Factory(IntEncoder encoder) {
            this.encoder = encoder;
        }

        @Override
        public IntFilter newFilter(int firstValue) {
            IntEncoder e = this.getIntEncoder(firstValue);
            return new IntEncodingFilter(e);
        }

        private IntEncoder getIntEncoder(int firstValue) {
            this.encoder.setContextValue(firstValue);
            return this.encoder;
        }
    }
}

