/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.LongCodec;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.encodings.DeltaZigzagEncoding;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.filters.LongFilter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.io.LongBufferOutputStream;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.io.LongOutputStream;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.packers.LongBitPacking;
import java.nio.LongBuffer;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongDZBP
extends LongCodec {
    private static final Logger logger = LoggerFactory.getLogger(LongDZBP.class);
    private final LongBitPacking bitPack;

    public LongDZBP setDebug(boolean value) {
        this.bitPack.setDebug(value);
        return this;
    }

    public boolean getDebug() {
        return this.bitPack.getDebug();
    }

    public LongDZBP(LongBitPacking bitPack) {
        this.bitPack = bitPack;
    }

    public LongDZBP() {
        this(new LongBitPacking());
    }

    public LongBitPacking getBitPacking() {
        return this.bitPack;
    }

    @Override
    public void compress(LongBuffer src, LongOutputStream dst) {
        int srcLen = src.remaining();
        if (srcLen == 0) {
            return;
        }
        dst.write(srcLen);
        long first = src.get();
        dst.write(first);
        DZEncodeFilter filter = new DZEncodeFilter(first);
        int chunkSize = this.bitPack.getBlockSize();
        int chunkRemain = src.remaining() % chunkSize;
        LongBuffer window = src.slice();
        window.limit(window.limit() - chunkRemain);
        this.bitPack.compress(window, dst, filter);
        src.position(src.position() + window.position());
        if (chunkRemain > 0) {
            long[] last = new long[chunkSize];
            src.get(last, 0, chunkRemain);
            Arrays.fill(last, chunkRemain, last.length, last[chunkRemain - 1]);
            this.bitPack.compress(LongBuffer.wrap(last), dst, filter);
        }
    }

    @Override
    public void decompress(LongBuffer src, LongOutputStream dst) {
        int chunkRemain;
        if (!src.hasRemaining()) {
            return;
        }
        int outLen = (int)src.get() - 1;
        long first = src.get();
        dst.write(first);
        DZDecodeFilter filter = new DZDecodeFilter(first);
        int chunkSize = this.bitPack.getBlockSize();
        int chunkNum = outLen / chunkSize;
        if (chunkNum > 0) {
            this.bitPack.decompress(src, dst, filter, chunkNum);
        }
        if ((chunkRemain = outLen % chunkSize) > 0) {
            long[] last = new long[chunkSize];
            LongBuffer buf = LongBuffer.wrap(last);
            this.bitPack.decompress(src, new LongBufferOutputStream(buf), filter, 1);
            dst.write(last, 0, chunkRemain);
        }
    }

    @Override
    protected int decompressLength(LongBuffer src) {
        src.mark();
        int outLen = (int)src.get();
        src.reset();
        logger.info("outLen:" + outLen);
        return outLen;
    }

    public static byte[] toBytes(long[] src) {
        return new LongDZBP().compress(src);
    }

    public static long[] fromBytes(byte[] src) {
        return new LongDZBP().decompress(src);
    }

    public static class DZDecodeFilter
    extends DeltaZigzagEncoding.LongDecoder
    implements LongFilter {
        private long savedContext = 0L;

        public DZDecodeFilter(long contextValue) {
            super(contextValue);
        }

        public DZDecodeFilter() {
            this(0L);
        }

        @Override
        public long filterLong(long value) {
            return this.decodeLong(value);
        }

        @Override
        public void saveContext() {
            this.savedContext = this.contextValue;
        }

        @Override
        public void restoreContext() {
            this.contextValue = this.savedContext;
        }

        @Override
        public void resetContext() {
            this.contextValue = 0L;
            this.savedContext = 0L;
        }
    }

    public static class DZEncodeFilter
    extends DeltaZigzagEncoding.LongEncoder
    implements LongFilter {
        private long savedContext = 0L;

        public DZEncodeFilter(long contextValue) {
            super(contextValue);
        }

        public DZEncodeFilter() {
            this(0L);
        }

        @Override
        public long filterLong(long value) {
            return this.encodeLong(value);
        }

        @Override
        public void saveContext() {
            this.savedContext = this.contextValue;
        }

        @Override
        public void restoreContext() {
            this.contextValue = this.savedContext;
        }

        @Override
        public void resetContext() {
            this.contextValue = 0L;
            this.savedContext = 0L;
        }
    }
}

