/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.IntCodec;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.encodings.DeltaEncoding;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.filters.IntEncodingFilter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.filters.IntFilterFactory;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.io.IntArrayOutputStream;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.io.IntDecompressStream;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.io.IntInputStream;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.io.IntOutputStream;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.packers.IntBitPacking;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.utils.CodecUtils;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.utils.Jaccard;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.utils.ReaderIterator;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class IntAscSDBP
extends IntCodec {
    private final IntBitPacking bitPack;
    private final IntFilterFactory encodeFilterFactory;
    private final IntFilterFactory decodeFilterFactory;

    public IntAscSDBP(IntBitPacking bitPack) {
        this.bitPack = bitPack;
        this.encodeFilterFactory = new IntEncodingFilter.Factory(new DeltaEncoding.IntAscendEncoder());
        this.decodeFilterFactory = new IntEncodingFilter.Factory(new DeltaEncoding.IntAscendDecoder());
    }

    public IntAscSDBP() {
        this(new IntBitPacking());
    }

    @Override
    public void compress(IntBuffer src, IntOutputStream dst) {
        CodecUtils.encodeBlockPack(src, this.encodeFilterFactory, this.bitPack, dst);
    }

    @Override
    public void decompress(IntBuffer src, IntOutputStream dst) {
        CodecUtils.decodeBlockPack(src, this.decodeFilterFactory, this.bitPack, dst);
    }

    public static byte[] toBytes(int[] src) {
        return new IntAscSDBP().compress(src);
    }

    public static int[] fromBytes(byte[] src) {
        return new IntAscSDBP().decompress(src);
    }

    public static Iterable<Integer> toIterable(final byte[] src) {
        return new Iterable<Integer>(){

            @Override
            public Iterator<Integer> iterator() {
                return new ReaderIterator(new IntDecompressStream(ByteBuffer.wrap(src).asIntBuffer(), new IntEncodingFilter.Factory(new DeltaEncoding.IntAscendDecoder()), new IntBitPacking()));
            }
        };
    }

    static Reader newBytesDecompressReader(ByteBuffer b) {
        IntDecompressStream ds = new IntDecompressStream(b.asIntBuffer(), new IntEncodingFilter.Factory(new DeltaEncoding.IntAscendDecoder()), new IntBitPacking());
        Reader r = new Reader(ds);
        r.read();
        return r;
    }

    static void skipEqualOrLessValues(List<Reader> readers, int n) {
        for (Reader r : readers) {
            Integer v = r.last();
            while (v != null && v <= n) {
                v = r.read();
            }
        }
    }

    static Integer fetchMinimumInt(List<Reader> readers) {
        Reader minR = null;
        for (Reader r : readers) {
            Integer v = r.last();
            if (v == null || minR != null && v >= minR.last()) continue;
            minR = r;
        }
        if (minR == null) {
            return null;
        }
        Integer minV = minR.last();
        IntAscSDBP.skipEqualOrLessValues(readers, minV);
        return minV;
    }

    static boolean allReadersHaveInt(List<Reader> readers, int n) {
        boolean retval = true;
        for (Reader r : readers) {
            Integer v = r.last();
            if (v != null && v == n) continue;
            retval = false;
            break;
        }
        IntAscSDBP.skipEqualOrLessValues(readers, n);
        return retval;
    }

    static boolean anyReadersHaveInt(List<Reader> readers, int n) {
        boolean retval = false;
        for (Reader r : readers) {
            Integer v = r.last();
            if (v == null || v != n) continue;
            retval = true;
            break;
        }
        IntAscSDBP.skipEqualOrLessValues(readers, n);
        return retval;
    }

    private static ByteBuffer[] toByteBufferArray(byte[][] bufArray) {
        ByteBuffer[] results = new ByteBuffer[bufArray.length];
        for (int i = 0; i < bufArray.length; ++i) {
            results[i] = ByteBuffer.wrap(bufArray[i]);
        }
        return results;
    }

    public static byte[] union(byte[] a, byte[] b, byte[] ... others) {
        return IntAscSDBP.union(ByteBuffer.wrap(a), ByteBuffer.wrap(b), IntAscSDBP.toByteBufferArray(others));
    }

    public static byte[] union(ByteBuffer a, ByteBuffer b, ByteBuffer ... others) {
        LinkedList<Reader> readers = new LinkedList<Reader>();
        readers.add(IntAscSDBP.newBytesDecompressReader(a));
        readers.add(IntAscSDBP.newBytesDecompressReader(b));
        for (ByteBuffer c : others) {
            readers.add(IntAscSDBP.newBytesDecompressReader(c));
        }
        return IntAscSDBP.toBytes(IntAscSDBP.union(readers).toIntArray());
    }

    public static IntArrayOutputStream union(List<Reader> readers) {
        Integer n;
        IntArrayOutputStream os = new IntArrayOutputStream();
        while ((n = IntAscSDBP.fetchMinimumInt(readers)) != null) {
            os.write(n);
        }
        return os;
    }

    public static byte[] intersect(byte[] a, byte[] b, byte[] ... others) {
        return IntAscSDBP.intersect(ByteBuffer.wrap(a), ByteBuffer.wrap(b), IntAscSDBP.toByteBufferArray(others));
    }

    public static byte[] intersect(ByteBuffer a, ByteBuffer b, ByteBuffer ... others) {
        Reader pivot = IntAscSDBP.newBytesDecompressReader(a);
        LinkedList<Reader> readers = new LinkedList<Reader>();
        readers.add(IntAscSDBP.newBytesDecompressReader(b));
        for (ByteBuffer c : others) {
            readers.add(IntAscSDBP.newBytesDecompressReader(c));
        }
        return IntAscSDBP.toBytes(IntAscSDBP.intersect(pivot, readers).toIntArray());
    }

    public static IntArrayOutputStream intersect(Reader pivot, List<Reader> readers) {
        IntArrayOutputStream os = new IntArrayOutputStream();
        Integer n = pivot.last;
        while (n != null) {
            if (IntAscSDBP.allReadersHaveInt(readers, n)) {
                os.write(n);
            }
            n = pivot.read();
        }
        return os;
    }

    public static byte[] difference(byte[] a, byte[] b, byte[] ... others) {
        return IntAscSDBP.difference(ByteBuffer.wrap(a), ByteBuffer.wrap(b), IntAscSDBP.toByteBufferArray(others));
    }

    public static byte[] difference(ByteBuffer a, ByteBuffer b, ByteBuffer ... others) {
        Reader pivot = IntAscSDBP.newBytesDecompressReader(a);
        LinkedList<Reader> readers = new LinkedList<Reader>();
        readers.add(IntAscSDBP.newBytesDecompressReader(b));
        for (ByteBuffer c : others) {
            readers.add(IntAscSDBP.newBytesDecompressReader(c));
        }
        return IntAscSDBP.toBytes(IntAscSDBP.difference(pivot, readers).toIntArray());
    }

    public static IntArrayOutputStream difference(Reader pivot, List<Reader> readers) {
        IntArrayOutputStream os = new IntArrayOutputStream();
        Integer v = pivot.last;
        while (v != null) {
            if (!IntAscSDBP.anyReadersHaveInt(readers, v)) {
                os.write(v);
            }
            v = pivot.read();
        }
        return os;
    }

    public static double jaccard(byte[] a, byte[] b) {
        return Jaccard.jaccard(IntAscSDBP.toIterable(a), IntAscSDBP.toIterable(b));
    }

    public static class Reader {
        IntInputStream stream;
        Integer last = null;

        public Reader(IntInputStream stream) {
            this.stream = stream;
        }

        public Integer read() {
            this.last = this.stream.read();
            return this.last;
        }

        public Integer last() {
            return this.last;
        }
    }
}

