/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricLevel;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.MetricObject;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.DataSource;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.DataSourceFile;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.IndexFile;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.LogFile;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.zigzag.LongDZBP;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.server.MetricsMemoryCache;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.status.LogDescriptionManager;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.status.LogDescriptionRegister;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.utils.FigureUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsLog {
    private static final Logger logger = LoggerFactory.getLogger(MetricsLog.class);
    private MetricsMemoryCache cache;
    private LogDescriptionRegister register;
    private LogDescriptionManager logDescriptionManager;
    public DataSourceFile dataSourceDescribe;
    public IndexFile indexDescribe;
    private LogFile logDescribe;
    private String dataSourceFileName;
    private String indexFileName;
    private String logFileName;
    private String basePath;
    private long baseTimestamp;
    private MetricLevel level;
    private Map<MetricObject, DataSource> dataSourceObjects = new HashMap<MetricObject, DataSource>();
    private byte[] dataSourceBlock;
    private long[] dataBlock;
    private int dataBlockIndex = 0;
    private int dataSourceBlockIndex = 0;
    private int dataSourceBlockSize = 4096;

    public MetricsLog(MetricLevel level, LogDescriptionRegister register, LogDescriptionManager logDescriptionManager, MetricsMemoryCache cache, String basePath, String dataSourceFileName, String indexFileName, String logFileName, long baseTimestamp) {
        this.level = level;
        this.basePath = basePath;
        this.dataSourceFileName = dataSourceFileName;
        this.indexFileName = indexFileName;
        this.logFileName = logFileName;
        this.register = register;
        this.logDescriptionManager = logDescriptionManager;
        this.cache = cache;
        this.baseTimestamp = baseTimestamp;
    }

    public void init() {
        File baseDir = new File(this.basePath);
        if (!baseDir.exists()) {
            baseDir.mkdirs();
        }
        File dataSourceFile = new File(this.dataSourceFileName);
        File indexFile = new File(this.indexFileName);
        File dataFile = new File(this.logFileName);
        this.dataSourceDescribe = new DataSourceFile(this.dataSourceFileName, this.level);
        this.indexDescribe = new IndexFile(this.indexFileName, this.level);
        this.logDescribe = new LogFile(this.logFileName, this.level);
        if (dataSourceFile.exists() && indexFile.exists() && dataFile.exists()) {
            try {
                this.dataSourceDescribe.init();
                this.indexDescribe.init();
                this.logDescribe.init();
                this.dataSourceDescribe.read(this.register);
            }
            catch (IOException e) {
                logger.error("Init metricslog error when files exist", e.fillInStackTrace());
            }
        } else {
            try {
                this.dataSourceDescribe.create();
                this.indexDescribe.create();
                this.logDescribe.create();
            }
            catch (IOException e) {
                logger.error("Init metricslog error when files not exist", e.fillInStackTrace());
            }
        }
    }

    public void write(long metricsTime, List<MetricObject> metrics) throws IOException {
        int offset = this.dataSourceDescribe.getCurrentOffset();
        int order = this.dataSourceDescribe.getCurrentOrder();
        int dataStart = (int)this.logDescribe.getPosition();
        int dataEnd = 0;
        for (MetricObject metricObject : metrics) {
            DataSource dataSource = this.register.getDataSource(metricObject);
            if (dataSource != null) continue;
            dataSource = new DataSource(metricObject, this.level, offset, order, metricsTime, metricObject.getMeterName());
            this.dataSourceObjects.put(metricObject, dataSource);
            ++order;
            offset += 8;
        }
        int length = order;
        this.dataBlock = new long[length];
        for (int i = 0; i < length; ++i) {
            this.dataBlock[i] = -10001L;
        }
        for (MetricObject metricObject : metrics) {
            Object o = metricObject.getValue();
            long value = FigureUtil.convertToLong(o);
            DataSource dataSource = this.register.getDataSource(metricObject);
            if (dataSource == null) {
                dataSource = this.dataSourceObjects.get(metricObject);
            }
            this.dataBlock[dataSource.getOrder()] = value;
            ++this.dataBlockIndex;
        }
        this.dataSourceBlock = new byte[this.dataSourceBlockSize];
        for (DataSource dataSource : this.dataSourceObjects.values()) {
            this.addDataSourceBytes(dataSource);
        }
        try {
            byte[] data = LongDZBP.toBytes(this.dataBlock);
            this.logDescribe.write(metricsTime, data);
            dataEnd = dataStart + data.length;
            this.indexDescribe.write(metricsTime, dataStart, (long)dataEnd);
            if (this.dataSourceObjects != null && this.dataSourceObjects.size() > 0) {
                this.dataSourceDescribe.write(metricsTime, this.dataSourceBlock, this.dataSourceObjects, this.dataSourceBlockIndex, offset);
            }
            this.cache.add(this.level, metricsTime, this.dataBlock);
            this.variableEffective(offset, order);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.statusClear();
        }
    }

    public void addDataSourceBytes(DataSource dataSource) {
        int oldLength;
        int newLength;
        byte[] dataSourceBytes = dataSource.toJsonBytes();
        for (newLength = oldLength = this.dataSourceBlock.length; this.dataSourceBlockIndex + dataSourceBytes.length + 1 > newLength; newLength *= 2) {
        }
        if (newLength > oldLength) {
            byte[] newDataSourceBlock = new byte[newLength];
            System.arraycopy(this.dataSourceBlock, 0, newDataSourceBlock, 0, oldLength);
            this.dataSourceBlock = newDataSourceBlock;
        }
        System.arraycopy(dataSourceBytes, 0, this.dataSourceBlock, this.dataSourceBlockIndex, dataSourceBytes.length);
        this.dataSourceBlock[this.dataSourceBlockIndex + dataSourceBytes.length] = 10;
        this.dataSourceBlockIndex = this.dataSourceBlockIndex + dataSourceBytes.length + 1;
    }

    public void statusClear() {
        this.dataSourceBlockIndex = 0;
        this.dataBlockIndex = 0;
        this.dataSourceObjects.clear();
    }

    public void variableEffective(int offset, int order) {
        this.dataSourceDescribe.setCurrentOffset(offset);
        this.dataSourceDescribe.setCurrentOrder(order);
        this.register.addDataSources(this.dataSourceObjects);
    }

    public void close() throws IOException {
        this.logDescribe.close();
        this.indexDescribe.close();
        this.dataSourceDescribe.close();
    }
}

