/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricLevel;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.config.MetricsCollectPeriodConfig;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.AbstractFileBackend;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.ChannelFileBackend;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.reporter.bin.IndexData;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.utils.FigureUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexFile {
    private static final Logger logger = LoggerFactory.getLogger(IndexFile.class);
    private String path;
    private AbstractFileBackend backend;
    private MetricLevel level;
    private static MetricsCollectPeriodConfig metricsCollectPeriodConfig = new MetricsCollectPeriodConfig();
    public static final int POINT_SIZE = 16;

    public IndexFile(String path, MetricLevel level) {
        this.path = path;
        this.level = level;
    }

    public void init() throws IOException {
        this.init(false);
    }

    public void init(boolean readOnly) throws IOException {
        this.backend = new ChannelFileBackend(this.path, readOnly);
        this.setLength();
    }

    public void create() throws IOException {
        File indexFile = new File(this.path);
        indexFile.createNewFile();
        this.init();
    }

    public void setLength() throws IOException {
        long indexFileLength = 86400 / metricsCollectPeriodConfig.period(this.level) * 16;
        if (this.backend.getLength() != indexFileLength) {
            this.backend.setLength(0L);
            this.backend.setLength(indexFileLength);
        }
    }

    public void write(long metricsTime, long indexStart, long indexEnd) throws IOException {
        long baseTimestamp = FigureUtil.getTodayStartTimestamp(metricsTime);
        long interval = metricsCollectPeriodConfig.period(this.level) * 1000;
        long ordinal = (metricsTime - baseTimestamp) / interval;
        long position = ordinal * 16L;
        byte[] b = this.getPositionBytes(indexStart, indexEnd);
        this.backend.write(position, b, 0, 16);
    }

    public void write(long metricsTime, byte[] indexBlock, int length) throws IOException {
        long position = this.backend.getLength();
        this.backend.write(position, indexBlock, 0, length);
    }

    public Map<Long, IndexData> read(long startTime, long endTime) {
        long fileLength;
        int pointNum;
        int length;
        if (endTime < startTime) {
            logger.warn("endtime {} < starttime {} when searching", (Object)endTime, (Object)startTime);
            return null;
        }
        HashMap<Long, IndexData> result = new HashMap<Long, IndexData>(0);
        int milliInterval = metricsCollectPeriodConfig.period(this.level) * 1000;
        byte[] indexBytes = null;
        startTime = startTime / (long)milliInterval * (long)milliInterval;
        endTime = endTime / (long)milliInterval * (long)milliInterval;
        long baseTimestamp = FigureUtil.getTodayStartTimestamp(startTime);
        int span = (int)((startTime - baseTimestamp) / (long)milliInterval);
        long offset = span * 16;
        if (offset + (long)(length = (pointNum = (int)((endTime - startTime) / (long)milliInterval) + 1) * 16) > (fileLength = this.backend.getLength())) {
            logger.warn("Offset:{} plus length:{} exceeds file length {}", offset, length, fileLength);
        }
        indexBytes = new byte[length];
        try {
            this.backend.read(offset, indexBytes);
        }
        catch (IOException e) {
            logger.error("Read indexFile {} error when searching!", (Object)this.path);
            return null;
        }
        pointNum = length / 16;
        long lastIndexEnd = 0L;
        for (int i = 0; i < pointNum; ++i) {
            long timestamp = startTime + (long)(i * milliInterval);
            long indexStart = FigureUtil.getLong(indexBytes, i * 16);
            long indexEnd = FigureUtil.getLong(indexBytes, i * 16 + 8);
            if (indexEnd <= 0L || indexStart >= indexEnd || indexStart < lastIndexEnd) continue;
            lastIndexEnd = indexEnd;
            result.put(timestamp, new IndexData(indexStart, indexEnd));
        }
        return result;
    }

    private byte[] getPositionBytes(long indexStart, long indexEnd) {
        int i;
        byte[] b = new byte[16];
        byte[] indexStartBytes = FigureUtil.getLongBytes(indexStart);
        byte[] indexEndBytes = FigureUtil.getLongBytes(indexEnd);
        for (i = 0; i < 8; ++i) {
            b[i] = indexStartBytes[i];
        }
        for (i = 0; i < 8; ++i) {
            b[i + 8] = indexEndBytes[i];
        }
        return b;
    }

    public void close() throws IOException {
        this.backend.sync();
        this.backend.close();
    }
}

