/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.windows;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.CachedMetricSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Clock;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Metric;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.PersistentGauge;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpGaugeSet
extends CachedMetricSet {
    private static final Logger logger = LoggerFactory.getLogger(TcpGaugeSet.class);
    private Map<MetricName, Metric> gauges = new HashMap<MetricName, Metric>();
    private static final String[] METRICS = new String[]{"tcp.active_opens", "tcp.passive_opens", "tcp.attempt_fails", "tcp.estab_resets", "tcp.in_segs", "tcp.out_segs", "tcp.retran_segs", "tcp.in_errs", "tcp.out_rsts"};
    private static final String CURRENT_ESTAB = "tcp.current_estab";
    private static final String RETRAN_RATIO = "tcp.retran_ratio";
    private long[] counters = new long[METRICS.length];
    private double[] rates = new double[METRICS.length];
    private long currentEstab;
    private double retranRatio;
    private boolean firstCollection = true;

    public TcpGaugeSet(long dataTTL, TimeUnit unit, Clock clock) {
        super(dataTTL, unit, clock);
        this.gauges = new HashMap<MetricName, Metric>();
        this.populateGauges();
    }

    @Override
    public Map<MetricName, Metric> getMetrics() {
        return this.gauges;
    }

    @Override
    protected void getValueInternal() {
    }

    private void populateGauges() {
        for (int i = 0; i < METRICS.length; ++i) {
            this.gauges.put(MetricName.build(METRICS[i]), new TcpGauge(i));
        }
        this.gauges.put(MetricName.build(CURRENT_ESTAB), new PersistentGauge<Long>(){

            @Override
            public Long getValue() {
                return TcpGaugeSet.this.currentEstab;
            }
        });
        this.gauges.put(MetricName.build(RETRAN_RATIO), new PersistentGauge<Double>(){

            @Override
            public Double getValue() {
                return TcpGaugeSet.this.retranRatio;
            }
        });
    }

    private class TcpGauge
    extends PersistentGauge<Double> {
        private int index;

        public TcpGauge(int index) {
            this.index = index;
        }

        @Override
        public Double getValue() {
            try {
                TcpGaugeSet.this.refreshIfNecessary();
                return TcpGaugeSet.this.rates[this.index];
            }
            catch (Exception e) {
                return 0.0;
            }
        }
    }
}

