/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.linux;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.CachedMetricSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Clock;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Metric;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.PersistentGauge;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.linux.SystemMemoryGaugeSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.utils.FileUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpGaugeSet
extends CachedMetricSet {
    private static final Logger logger = LoggerFactory.getLogger(SystemMemoryGaugeSet.class);
    private static final String DEFAULT_FILE_PATH = "/proc/net/snmp";
    private static final String[] METRICS = new String[]{"tcp.active_opens", "tcp.passive_opens", "tcp.attempt_fails", "tcp.estab_resets", "tcp.in_segs", "tcp.out_segs", "tcp.retran_segs", "tcp.in_errs", "tcp.out_rsts"};
    private static final String CURRENT_ESTAB = "tcp.current_estab";
    private static final String RETRAN_RATIO = "tcp.retran_ratio";
    private static final String SPACE_REGEX = "\\s+";
    private String filePath;
    private long[] counters;
    private double[] rates;
    private long currentEstab;
    private double retranRatio;
    private boolean firstCollection;
    private Map<MetricName, Metric> gauges;

    public TcpGaugeSet() {
        this(DEFAULT_FILE_PATH, DEFAULT_DATA_TTL, TimeUnit.MILLISECONDS, Clock.defaultClock());
    }

    public TcpGaugeSet(String filePath) {
        this(filePath, DEFAULT_DATA_TTL, TimeUnit.MILLISECONDS, Clock.defaultClock());
    }

    public TcpGaugeSet(long dataTTL, TimeUnit unit) {
        this(DEFAULT_FILE_PATH, dataTTL, unit, Clock.defaultClock());
    }

    public TcpGaugeSet(String filePath, long dataTTL, TimeUnit unit, Clock clock) {
        super(dataTTL, unit, clock);
        this.filePath = filePath;
        this.counters = new long[METRICS.length];
        this.rates = new double[METRICS.length];
        this.gauges = new HashMap<MetricName, Metric>();
        this.firstCollection = true;
        this.populateGauges();
    }

    @Override
    protected void getValueInternal() {
        try {
            List<String> lines = FileUtils.readFileAsStringArray(this.filePath);
            for (String line : lines) {
                String[] tokens;
                if (!line.startsWith("Tcp:") || !Character.isDigit((tokens = line.split(SPACE_REGEX))[1].charAt(0))) continue;
                long[] counts = new long[]{Long.parseLong(tokens[5]), Long.parseLong(tokens[6]), Long.parseLong(tokens[7]), Long.parseLong(tokens[8]), Long.parseLong(tokens[10]), Long.parseLong(tokens[11]), Long.parseLong(tokens[12]), Long.parseLong(tokens[13]), Long.parseLong(tokens[14])};
                if (!this.firstCollection) {
                    long[] deltas = new long[this.counters.length];
                    for (int i = 0; i < this.counters.length; ++i) {
                        deltas[i] = counts[i] - this.counters[i];
                    }
                    long duration = this.clock.getTime() - this.lastCollectTime.get();
                    for (int i = 0; i < this.counters.length; ++i) {
                        this.rates[i] = 1000.0 * (double)deltas[i] / (double)duration;
                    }
                    this.retranRatio = 1.0 * (double)deltas[6] / (double)deltas[5];
                }
                System.arraycopy(counts, 0, this.counters, 0, this.counters.length);
                this.currentEstab = Long.parseLong(tokens[9]);
                if (!this.firstCollection) continue;
                this.firstCollection = false;
            }
        }
        catch (IOException e) {
            logger.warn("Error during reading file {}", (Object)this.filePath, (Object)e);
        }
    }

    @Override
    public Map<MetricName, Metric> getMetrics() {
        return this.gauges;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    private void populateGauges() {
        for (int i = 0; i < METRICS.length; ++i) {
            this.gauges.put(MetricName.build(METRICS[i]), new TcpGauge(i));
        }
        this.gauges.put(MetricName.build(CURRENT_ESTAB), new PersistentGauge<Long>(){

            @Override
            public Long getValue() {
                return TcpGaugeSet.this.currentEstab;
            }
        });
        this.gauges.put(MetricName.build(RETRAN_RATIO), new PersistentGauge<Double>(){

            @Override
            public Double getValue() {
                return TcpGaugeSet.this.retranRatio;
            }
        });
    }

    private class TcpGauge
    extends PersistentGauge<Double> {
        private int index;

        public TcpGauge(int index) {
            this.index = index;
        }

        @Override
        public Double getValue() {
            try {
                TcpGaugeSet.this.refreshIfNecessary();
                return TcpGaugeSet.this.rates[this.index];
            }
            catch (Exception e) {
                return 0.0;
            }
        }
    }
}

