/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.linux;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.CachedMetricSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Clock;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Gauge;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Metric;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.PersistentGauge;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.RatioGauge;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.os.utils.FileUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemMemoryGaugeSet
extends CachedMetricSet {
    private static final Logger logger = LoggerFactory.getLogger(SystemMemoryGaugeSet.class);
    private static final String DEFAULT_FILE_PATH = "/proc/meminfo";
    private static final String SPACE_REGEX = "\\s+";
    private static final String[] METRICS = new String[]{"mem.total", "mem.used", "mem.free", "mem.buffers", "mem.cached", "mem.swap.total", "mem.swap.used", "mem.swap.free"};
    private String filePath;
    private long[] data;
    private Map<MetricName, Metric> gauges;

    public SystemMemoryGaugeSet() {
        this(DEFAULT_FILE_PATH, DEFAULT_DATA_TTL, TimeUnit.MILLISECONDS, Clock.defaultClock());
    }

    public SystemMemoryGaugeSet(String filePath) {
        this(filePath, DEFAULT_DATA_TTL, TimeUnit.MILLISECONDS, Clock.defaultClock());
    }

    public SystemMemoryGaugeSet(long dataTTL, TimeUnit unit) {
        this(DEFAULT_FILE_PATH, dataTTL, unit, Clock.defaultClock());
    }

    public SystemMemoryGaugeSet(String filePath, long dataTTL, TimeUnit unit, Clock clock) {
        super(dataTTL, unit, clock);
        this.filePath = filePath;
        this.data = new long[METRICS.length];
        this.gauges = new HashMap<MetricName, Metric>();
        this.populateGauges();
    }

    @Override
    protected void getValueInternal() {
        try {
            List<String> lines = FileUtils.readFileAsStringArray(this.filePath);
            for (String line : lines) {
                if (line.startsWith("MemTotal:")) {
                    this.data[0] = Long.parseLong(line.split(SPACE_REGEX)[1]);
                    continue;
                }
                if (line.startsWith("MemFree:")) {
                    this.data[2] = Long.parseLong(line.split(SPACE_REGEX)[1]);
                    continue;
                }
                if (line.startsWith("Buffers:")) {
                    this.data[3] = Long.parseLong(line.split(SPACE_REGEX)[1]);
                    continue;
                }
                if (line.startsWith("Cached:")) {
                    this.data[4] = Long.parseLong(line.split(SPACE_REGEX)[1]);
                    continue;
                }
                if (line.startsWith("SwapTotal:")) {
                    this.data[5] = Long.parseLong(line.split(SPACE_REGEX)[1]);
                    continue;
                }
                if (!line.startsWith("SwapFree:")) continue;
                this.data[7] = Long.parseLong(line.split(SPACE_REGEX)[1]);
            }
            this.data[1] = this.data[0] - this.data[2] - this.data[3] - this.data[4];
            this.data[6] = this.data[5] - this.data[7];
        }
        catch (IOException e) {
            logger.warn("Error during reading file {}", (Object)this.filePath, (Object)e);
        }
    }

    @Override
    public Map<MetricName, Metric> getMetrics() {
        return this.gauges;
    }

    private void populateGauges() {
        for (int i = 0; i < METRICS.length; ++i) {
            this.gauges.put(MetricName.build(METRICS[i]), new MemGauge(i));
        }
        RatioGauge usedRatio = new RatioGauge(){

            @Override
            protected RatioGauge.Ratio getRatio() {
                Gauge memUsed = (Gauge)SystemMemoryGaugeSet.this.gauges.get(MetricName.build("mem.used"));
                Gauge memTotal = (Gauge)SystemMemoryGaugeSet.this.gauges.get(MetricName.build("mem.total"));
                return RatioGauge.Ratio.of(((Long)memUsed.getValue()).doubleValue(), ((Long)memTotal.getValue()).doubleValue());
            }
        };
        this.gauges.put(MetricName.build("mem.used_ratio"), usedRatio);
    }

    private class MemGauge
    extends PersistentGauge<Long> {
        private int index;

        public MemGauge(int index) {
            this.index = index;
        }

        @Override
        public Long getValue() {
            try {
                SystemMemoryGaugeSet.this.refreshIfNecessary();
                return SystemMemoryGaugeSet.this.data[this.index];
            }
            catch (Exception e) {
                return 0L;
            }
        }
    }
}

