/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.jvm;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.CachedGauge;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.RatioGauge;
import com.sun.management.UnixOperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;

public class FileDescriptorRatioGauge
extends RatioGauge {
    private final OperatingSystemMXBean os;
    private final CachedGauge<RatioGauge.Ratio> cachedRatio;

    public FileDescriptorRatioGauge() {
        this(ManagementFactory.getOperatingSystemMXBean(), 1L, TimeUnit.MINUTES);
    }

    public FileDescriptorRatioGauge(OperatingSystemMXBean os) {
        this(os, 1L, TimeUnit.MINUTES);
    }

    public FileDescriptorRatioGauge(OperatingSystemMXBean os, long timeout, TimeUnit unit) {
        this.os = os;
        this.cachedRatio = new CachedGauge<RatioGauge.Ratio>(timeout, unit){

            @Override
            protected RatioGauge.Ratio loadValue() {
                return FileDescriptorRatioGauge.this.getRatioInternal();
            }
        };
    }

    @Override
    protected RatioGauge.Ratio getRatio() {
        return this.cachedRatio.getValue();
    }

    private RatioGauge.Ratio getRatioInternal() {
        if (this.os instanceof UnixOperatingSystemMXBean) {
            UnixOperatingSystemMXBean unixOs = (UnixOperatingSystemMXBean)this.os;
            return RatioGauge.Ratio.of(unixOs.getOpenFileDescriptorCount(), unixOs.getMaxFileDescriptorCount());
        }
        return RatioGauge.Ratio.of(Double.NaN, Double.NaN);
    }

    private long invoke(String name) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = this.os.getClass().getDeclaredMethod(name, new Class[0]);
        method.setAccessible(true);
        return (Long)method.invoke((Object)this.os, new Object[0]);
    }
}

