/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics.jvm;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.JmxAttributeGauge;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Metric;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricRegistry;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricSet;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferPoolMetricSet
implements MetricSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(BufferPoolMetricSet.class);
    private static final String[] ATTRIBUTES = new String[]{"Count", "MemoryUsed", "TotalCapacity"};
    private static final String[] NAMES = new String[]{"count", "used", "capacity"};
    private static final String[] POOLS = new String[]{"direct", "mapped"};
    private final MBeanServerConnection mBeanServerConnection;

    public BufferPoolMetricSet(MBeanServerConnection mBeanServerConnection) {
        this.mBeanServerConnection = mBeanServerConnection;
    }

    @Override
    public Map<MetricName, Metric> getMetrics() {
        HashMap<MetricName, JmxAttributeGauge> gauges = new HashMap<MetricName, JmxAttributeGauge>();
        for (String pool : POOLS) {
            for (int i = 0; i < ATTRIBUTES.length; ++i) {
                String attribute = ATTRIBUTES[i];
                String name = NAMES[i];
                try {
                    ObjectName on = new ObjectName("java.nio:type=BufferPool,name=" + pool);
                    this.mBeanServerConnection.getMBeanInfo(on);
                    gauges.put(MetricRegistry.name(pool, name), new JmxAttributeGauge(this.mBeanServerConnection, on, attribute));
                    continue;
                }
                catch (JMException ignored) {
                    LOGGER.debug("Unable to load buffer pool MBeans, possibly running on Java 6");
                    continue;
                }
                catch (IOException ioException) {
                    LOGGER.debug("Unable to load buffer pool MBeans, an exception occur, cause of", ioException);
                }
            }
        }
        return Collections.unmodifiableMap(gauges);
    }

    @Override
    public long lastUpdateTime() {
        return System.currentTimeMillis();
    }
}

