/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.BucketCounterImpl;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Clock;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.ClusterHistogram;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.ClusterHistogramBuilder;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.ClusterHistogramImpl;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Compass;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.CompassImpl;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Counter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.DynamicMetricSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.FastCompass;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.FastCompassImpl;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Gauge;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Histogram;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.HistogramImpl;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Meter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MeterImpl;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Metric;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricBuilder;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricFilter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricName;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricRegistry;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricRegistryListener;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.MetricSet;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.NOPMetricManager;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.ReservoirType;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.ReservoirTypeBuilder;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Timer;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.TimerImpl;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.common.config.MetricsCollectPeriodConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class MetricRegistryImpl
extends MetricRegistry {
    private static final int DEFAULT_MAX_METRIC_COUNT = Integer.getInteger("com.alibaba.csp.ahas.shaded.com.alibaba.metrics.maxMetricCountPerRegistry", 5000);
    private static final MetricsCollectPeriodConfig config = new MetricsCollectPeriodConfig();
    private final ConcurrentMap<MetricName, Metric> metrics;
    private final List<MetricRegistryListener> listeners;
    private final int maxMetricCount;
    private MetricBuilder<Counter> COUNTER_BUILDER = new MetricBuilder<Counter>(){

        @Override
        public Counter newMetric(MetricName name) {
            if (MetricRegistryImpl.this.metrics.size() >= MetricRegistryImpl.this.maxMetricCount) {
                return null;
            }
            return new BucketCounterImpl(config.period(name.getMetricLevel()));
        }

        @Override
        public boolean isInstance(Metric metric) {
            return Counter.class.isInstance(metric);
        }
    };
    private ReservoirTypeBuilder<Histogram> HISTOGRAM_BUILDER = new ReservoirTypeBuilder<Histogram>(){

        @Override
        public Histogram newMetric(MetricName name, ReservoirType type) {
            if (MetricRegistryImpl.this.metrics.size() >= MetricRegistryImpl.this.maxMetricCount) {
                return null;
            }
            return new HistogramImpl(config.period(name.getMetricLevel()), type);
        }

        public Histogram newMetric(MetricName name) {
            if (MetricRegistryImpl.this.metrics.size() >= MetricRegistryImpl.this.maxMetricCount) {
                return null;
            }
            return new HistogramImpl(config.period(name.getMetricLevel()));
        }

        @Override
        public boolean isInstance(Metric metric) {
            return Histogram.class.isInstance(metric);
        }
    };
    private MetricBuilder<Meter> METER_BUILDER = new MetricBuilder<Meter>(){

        @Override
        public Meter newMetric(MetricName name) {
            if (MetricRegistryImpl.this.metrics.size() >= MetricRegistryImpl.this.maxMetricCount) {
                return null;
            }
            return new MeterImpl(config.period(name.getMetricLevel()));
        }

        @Override
        public boolean isInstance(Metric metric) {
            return Meter.class.isInstance(metric);
        }
    };
    private ReservoirTypeBuilder<Timer> TIMER_BUILDER = new ReservoirTypeBuilder<Timer>(){

        public Timer newMetric(MetricName name) {
            if (MetricRegistryImpl.this.metrics.size() >= MetricRegistryImpl.this.maxMetricCount) {
                return null;
            }
            return new TimerImpl(config.period(name.getMetricLevel()));
        }

        @Override
        public Timer newMetric(MetricName name, ReservoirType type) {
            if (MetricRegistryImpl.this.metrics.size() >= MetricRegistryImpl.this.maxMetricCount) {
                return null;
            }
            return new TimerImpl(config.period(name.getMetricLevel()), type);
        }

        @Override
        public boolean isInstance(Metric metric) {
            return Timer.class.isInstance(metric);
        }
    };
    private ReservoirTypeBuilder<Compass> COMPASS_BUILDER = new ReservoirTypeBuilder<Compass>(){

        public Compass newMetric(MetricName name) {
            if (MetricRegistryImpl.this.metrics.size() >= MetricRegistryImpl.this.maxMetricCount) {
                return null;
            }
            return new CompassImpl(config.period(name.getMetricLevel()));
        }

        @Override
        public Compass newMetric(MetricName name, ReservoirType type) {
            if (MetricRegistryImpl.this.metrics.size() >= MetricRegistryImpl.this.maxMetricCount) {
                return null;
            }
            return new CompassImpl(config.period(name.getMetricLevel()), type);
        }

        @Override
        public boolean isInstance(Metric metric) {
            return Compass.class.isInstance(metric);
        }
    };
    private MetricBuilder<FastCompass> FAST_COMPASS_BUILDER = new MetricBuilder<FastCompass>(){

        @Override
        public FastCompass newMetric(MetricName name) {
            if (MetricRegistryImpl.this.metrics.size() >= MetricRegistryImpl.this.maxMetricCount) {
                return null;
            }
            return new FastCompassImpl(config.period(name.getMetricLevel()));
        }

        @Override
        public boolean isInstance(Metric metric) {
            return FastCompass.class.isInstance(metric);
        }
    };
    private ClusterHistogramBuilder<ClusterHistogram> CLUSTER_HISTOGRAM_BUILDER = new ClusterHistogramBuilder<ClusterHistogram>(){

        @Override
        public ClusterHistogram newMetric(MetricName name, long[] buckets) {
            if (MetricRegistryImpl.this.metrics.size() >= MetricRegistryImpl.this.maxMetricCount) {
                return null;
            }
            return new ClusterHistogramImpl(buckets, config.period(name.getMetricLevel()), Clock.defaultClock());
        }

        public ClusterHistogram newMetric(MetricName name) {
            if (MetricRegistryImpl.this.metrics.size() >= MetricRegistryImpl.this.maxMetricCount) {
                return null;
            }
            return new ClusterHistogramImpl(config.period(name.getMetricLevel()), Clock.defaultClock());
        }

        @Override
        public boolean isInstance(Metric metric) {
            return metric instanceof ClusterHistogram;
        }
    };

    public MetricRegistryImpl() {
        this(DEFAULT_MAX_METRIC_COUNT);
    }

    public MetricRegistryImpl(int maxMetricCount) {
        this.metrics = new ConcurrentHashMap<MetricName, Metric>();
        this.listeners = new CopyOnWriteArrayList<MetricRegistryListener>();
        this.maxMetricCount = maxMetricCount;
    }

    @Override
    public <T extends Metric> T register(String name, T metric) throws IllegalArgumentException {
        return this.register(MetricName.build(name), metric);
    }

    public void unRegisterAll() {
        this.metrics.clear();
    }

    @Override
    public <T extends Metric> T register(MetricName name, T metric) throws IllegalArgumentException {
        if (metric instanceof MetricSet && !(metric instanceof DynamicMetricSet)) {
            this.registerAll(name, (MetricSet)metric);
        } else {
            Metric existing = this.metrics.putIfAbsent(name, metric);
            if (existing == null) {
                this.onMetricAdded(name, metric);
            } else {
                throw new IllegalArgumentException("A metric named " + name + " already exists");
            }
        }
        return metric;
    }

    @Override
    public void registerAll(MetricSet metrics) throws IllegalArgumentException {
        this.registerAll(null, metrics);
    }

    @Override
    public Counter counter(String name) {
        return this.counter(MetricName.build(name));
    }

    @Override
    public Counter counter(MetricName name) {
        Counter counter = this.getOrAdd(name, this.COUNTER_BUILDER);
        if (counter == null) {
            return NOPMetricManager.NOP_COUNTER;
        }
        return counter;
    }

    @Override
    public Histogram histogram(String name) {
        return this.histogram(MetricName.build(name));
    }

    @Override
    public Histogram histogram(MetricName name) {
        return this.histogram(name, ReservoirType.EXPONENTIALLY_DECAYING);
    }

    @Override
    public Histogram histogram(MetricName name, ReservoirType type) {
        Histogram histogram = this.getOrAdd(name, this.HISTOGRAM_BUILDER, type);
        if (histogram == null) {
            return NOPMetricManager.NOP_HISTOGRAM;
        }
        return histogram;
    }

    @Override
    public Meter meter(String name) {
        return this.meter(MetricName.build(name));
    }

    @Override
    public Meter meter(MetricName name) {
        Meter meter = this.getOrAdd(name, this.METER_BUILDER);
        if (meter == null) {
            return NOPMetricManager.NOP_METER;
        }
        return meter;
    }

    @Override
    public Timer timer(String name) {
        return this.timer(MetricName.build(name));
    }

    @Override
    public Timer timer(MetricName name) {
        return this.timer(name, ReservoirType.EXPONENTIALLY_DECAYING);
    }

    @Override
    public Timer timer(MetricName name, ReservoirType type) {
        Timer timer = this.getOrAdd(name, this.TIMER_BUILDER, type);
        if (timer == null) {
            return NOPMetricManager.NOP_TIMER;
        }
        return timer;
    }

    @Override
    public Compass compass(MetricName name) {
        return this.compass(name, ReservoirType.EXPONENTIALLY_DECAYING);
    }

    @Override
    public Compass compass(MetricName name, ReservoirType type) {
        Compass compass = this.getOrAdd(name, this.COMPASS_BUILDER, type);
        if (compass == null) {
            return NOPMetricManager.NOP_COMPASS;
        }
        return compass;
    }

    @Override
    public Compass compass(String name) {
        return this.compass(MetricName.build(name));
    }

    @Override
    public FastCompass fastCompass(MetricName name) {
        FastCompass compass = this.getOrAdd(name, this.FAST_COMPASS_BUILDER);
        if (compass == null) {
            return NOPMetricManager.NOP_FAST_COMPASS;
        }
        return compass;
    }

    @Override
    public ClusterHistogram clusterHistogram(MetricName name, long[] buckets) {
        ClusterHistogram clusterHistogram = this.getOrAddClusterHistogram(name, this.CLUSTER_HISTOGRAM_BUILDER, buckets);
        if (clusterHistogram == null) {
            return NOPMetricManager.NOP_CLUSTER_HISTOGRAM;
        }
        return clusterHistogram;
    }

    @Override
    public boolean remove(MetricName name) {
        Metric metric = (Metric)this.metrics.remove(name);
        if (metric != null) {
            this.onMetricRemoved(name, metric);
            return true;
        }
        return false;
    }

    @Override
    public void removeMatching(MetricFilter filter) {
        for (Map.Entry entry : this.metrics.entrySet()) {
            if (!filter.matches((MetricName)entry.getKey(), (Metric)entry.getValue())) continue;
            this.remove((MetricName)entry.getKey());
        }
    }

    @Override
    public void addListener(MetricRegistryListener listener) {
        this.listeners.add(listener);
        for (Map.Entry entry : this.metrics.entrySet()) {
            this.notifyListenerOfAddedMetric(listener, (Metric)entry.getValue(), (MetricName)entry.getKey());
        }
    }

    @Override
    public void removeListener(MetricRegistryListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public SortedSet<MetricName> getNames() {
        return Collections.unmodifiableSortedSet(new TreeSet(this.metrics.keySet()));
    }

    @Override
    public SortedMap<MetricName, Gauge> getGauges() {
        return this.getGauges(MetricFilter.ALL);
    }

    @Override
    public SortedMap<MetricName, Gauge> getGauges(MetricFilter filter) {
        return this.getMetrics(Gauge.class, filter);
    }

    @Override
    public SortedMap<MetricName, Counter> getCounters() {
        return this.getCounters(MetricFilter.ALL);
    }

    @Override
    public SortedMap<MetricName, Counter> getCounters(MetricFilter filter) {
        return this.getMetrics(Counter.class, filter);
    }

    @Override
    public SortedMap<MetricName, Histogram> getHistograms() {
        return this.getHistograms(MetricFilter.ALL);
    }

    @Override
    public SortedMap<MetricName, Histogram> getHistograms(MetricFilter filter) {
        return this.getMetrics(Histogram.class, filter);
    }

    @Override
    public SortedMap<MetricName, Meter> getMeters() {
        return this.getMeters(MetricFilter.ALL);
    }

    @Override
    public SortedMap<MetricName, Meter> getMeters(MetricFilter filter) {
        return this.getMetrics(Meter.class, filter);
    }

    @Override
    public SortedMap<MetricName, Timer> getTimers() {
        return this.getTimers(MetricFilter.ALL);
    }

    @Override
    public SortedMap<MetricName, Timer> getTimers(MetricFilter filter) {
        return this.getMetrics(Timer.class, filter);
    }

    @Override
    public SortedMap<MetricName, Compass> getCompasses(MetricFilter filter) {
        return this.getMetrics(Compass.class, filter);
    }

    @Override
    public SortedMap<MetricName, Compass> getCompasses() {
        return this.getCompasses(MetricFilter.ALL);
    }

    @Override
    public SortedMap<MetricName, FastCompass> getFastCompasses() {
        return this.getFastCompasses(MetricFilter.ALL);
    }

    @Override
    public SortedMap<MetricName, FastCompass> getFastCompasses(MetricFilter filter) {
        return this.getMetrics(FastCompass.class, filter);
    }

    @Override
    public SortedMap<MetricName, ClusterHistogram> getClusterHistograms(MetricFilter filter) {
        return this.getMetrics(ClusterHistogram.class, filter);
    }

    @Override
    public SortedMap<MetricName, ClusterHistogram> getClusterHistograms() {
        return this.getMetrics(ClusterHistogram.class, MetricFilter.ALL);
    }

    @Override
    public SortedMap<MetricName, Metric> getMetrics(MetricFilter filter) {
        TreeMap<MetricName, Metric> filteredMetrics = new TreeMap<MetricName, Metric>();
        filteredMetrics.putAll(this.getCounters(filter));
        filteredMetrics.putAll(this.getMeters(filter));
        filteredMetrics.putAll(this.getHistograms(filter));
        filteredMetrics.putAll(this.getGauges(filter));
        filteredMetrics.putAll(this.getTimers(filter));
        filteredMetrics.putAll(this.getCompasses(filter));
        filteredMetrics.putAll(this.getFastCompasses(filter));
        filteredMetrics.putAll(this.getClusterHistograms(filter));
        return Collections.unmodifiableSortedMap(filteredMetrics);
    }

    @Override
    public long lastUpdateTime() {
        long latest = 0L;
        HashMap<MetricName, Metric> metrics = new HashMap<MetricName, Metric>();
        metrics.putAll(this.getCounters(MetricFilter.ALL));
        metrics.putAll(this.getMeters(MetricFilter.ALL));
        metrics.putAll(this.getHistograms(MetricFilter.ALL));
        metrics.putAll(this.getGauges(MetricFilter.ALL));
        metrics.putAll(this.getTimers(MetricFilter.ALL));
        metrics.putAll(this.getCompasses(MetricFilter.ALL));
        metrics.putAll(this.getFastCompasses(MetricFilter.ALL));
        metrics.putAll(this.getClusterHistograms(MetricFilter.ALL));
        for (Map.Entry entry : metrics.entrySet()) {
            if (latest >= ((Metric)entry.getValue()).lastUpdateTime()) continue;
            latest = ((Metric)entry.getValue()).lastUpdateTime();
        }
        return latest;
    }

    private <T extends Metric> T getOrAdd(MetricName name, MetricBuilder<T> builder) {
        Metric metric = (Metric)this.metrics.get(name);
        if (builder.isInstance(metric)) {
            return (T)metric;
        }
        if (metric == null) {
            try {
                T newMetric = builder.newMetric(name);
                if (newMetric == null) {
                    return null;
                }
                return this.register(name, newMetric);
            }
            catch (IllegalArgumentException e) {
                Metric added = (Metric)this.metrics.get(name);
                if (builder.isInstance(added)) {
                    return (T)added;
                }
                throw e;
            }
        }
        throw new IllegalArgumentException(name + " is already used for a different type of metric");
    }

    private <T extends Metric> T getOrAdd(MetricName name, ReservoirTypeBuilder<T> builder, ReservoirType type) {
        Metric metric = (Metric)this.metrics.get(name);
        if (builder.isInstance(metric)) {
            return (T)metric;
        }
        if (metric == null) {
            try {
                Metric newMetric = (Metric)builder.newMetric(name, type);
                if (newMetric == null) {
                    return null;
                }
                return (T)this.register(name, newMetric);
            }
            catch (IllegalArgumentException e) {
                Metric added = (Metric)this.metrics.get(name);
                if (builder.isInstance(added)) {
                    return (T)added;
                }
                throw e;
            }
        }
        throw new IllegalArgumentException(name + " is already used for a different type of metric");
    }

    private <T extends Metric> T getOrAddClusterHistogram(MetricName name, ClusterHistogramBuilder<T> builder, long[] buckets) {
        Metric metric = (Metric)this.metrics.get(name);
        if (builder.isInstance(metric)) {
            return (T)metric;
        }
        if (metric == null) {
            try {
                Metric newMetric = (Metric)builder.newMetric(name, buckets);
                if (newMetric == null) {
                    return null;
                }
                return (T)this.register(name, newMetric);
            }
            catch (IllegalArgumentException e) {
                Metric added = (Metric)this.metrics.get(name);
                if (builder.isInstance(added)) {
                    return (T)added;
                }
                throw e;
            }
        }
        throw new IllegalArgumentException(name + " is already used for a different type of metric");
    }

    private <T extends Metric> SortedMap<MetricName, T> getMetrics(Class<T> klass, MetricFilter filter) {
        TreeMap timers = new TreeMap();
        for (Map.Entry entry : this.metrics.entrySet()) {
            if (klass.isInstance(entry.getValue()) && filter.matches((MetricName)entry.getKey(), (Metric)entry.getValue())) {
                timers.put(entry.getKey(), (Metric)entry.getValue());
                continue;
            }
            if (!(entry.getValue() instanceof DynamicMetricSet)) continue;
            for (Map.Entry<MetricName, Metric> dynamicEntry : ((DynamicMetricSet)entry.getValue()).getDynamicMetrics().entrySet()) {
                if (!klass.isInstance(dynamicEntry.getValue()) || !filter.matches(dynamicEntry.getKey(), dynamicEntry.getValue())) continue;
                timers.put(dynamicEntry.getKey(), dynamicEntry.getValue());
            }
        }
        return Collections.unmodifiableSortedMap(timers);
    }

    private void onMetricAdded(MetricName name, Metric metric) {
        for (MetricRegistryListener listener : this.listeners) {
            this.notifyListenerOfAddedMetric(listener, metric, name);
        }
    }

    private void notifyListenerOfAddedMetric(MetricRegistryListener listener, Metric metric, MetricName name) {
        if (metric instanceof Gauge) {
            listener.onGaugeAdded(name, (Gauge)metric);
        } else if (metric instanceof Counter) {
            listener.onCounterAdded(name, (Counter)metric);
        } else if (metric instanceof Histogram) {
            listener.onHistogramAdded(name, (Histogram)metric);
        } else if (metric instanceof Meter) {
            listener.onMeterAdded(name, (Meter)metric);
        } else if (metric instanceof Timer) {
            listener.onTimerAdded(name, (Timer)metric);
        } else if (metric instanceof Compass) {
            listener.onCompassAdded(name, (Compass)metric);
        } else if (metric instanceof FastCompass) {
            listener.onFastCompassAdded(name, (FastCompass)metric);
        } else {
            throw new IllegalArgumentException("Unknown metric type: " + metric.getClass());
        }
    }

    private void onMetricRemoved(MetricName name, Metric metric) {
        for (MetricRegistryListener listener : this.listeners) {
            this.notifyListenerOfRemovedMetric(name, metric, listener);
        }
    }

    private void notifyListenerOfRemovedMetric(MetricName name, Metric metric, MetricRegistryListener listener) {
        if (metric instanceof Gauge) {
            listener.onGaugeRemoved(name);
        } else if (metric instanceof Counter) {
            listener.onCounterRemoved(name);
        } else if (metric instanceof Histogram) {
            listener.onHistogramRemoved(name);
        } else if (metric instanceof Meter) {
            listener.onMeterRemoved(name);
        } else if (metric instanceof Timer) {
            listener.onTimerRemoved(name);
        } else if (metric instanceof Compass) {
            listener.onCompassRemoved(name);
        } else if (metric instanceof FastCompass) {
            listener.onFastCompassRemoved(name);
        } else {
            throw new IllegalArgumentException("Unknown metric type: " + metric.getClass());
        }
    }

    private void registerAll(MetricName prefix, MetricSet metrics) throws IllegalArgumentException {
        if (prefix == null) {
            prefix = MetricName.EMPTY;
        }
        for (Map.Entry<MetricName, Metric> entry : metrics.getMetrics().entrySet()) {
            if (entry.getValue() instanceof MetricSet && !(entry.getValue() instanceof DynamicMetricSet)) {
                this.registerAll(MetricName.join(prefix, entry.getKey()), (MetricSet)entry.getValue());
                continue;
            }
            this.register(MetricName.join(prefix, entry.getKey()), entry.getValue());
        }
    }

    @Override
    public Map<MetricName, Metric> getMetrics() {
        return Collections.unmodifiableMap(this.metrics);
    }
}

