/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.BucketCounter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.BucketCounterImpl;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.BucketSnapshot;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Clock;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Reservoir;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Snapshot;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class BucketReservoir
implements Reservoir {
    private BucketCounter countPerBucket;
    private BucketCounter valuePerBucket;
    private Clock clock;
    private int interval;

    public BucketReservoir(int interval, int numberOfBucket, Clock clock, BucketCounter count) {
        this.clock = clock;
        this.interval = interval;
        this.valuePerBucket = new BucketCounterImpl(interval, numberOfBucket, clock);
        this.countPerBucket = count;
    }

    @Override
    public int size() {
        return (int)this.countPerBucket.getCount();
    }

    @Override
    public void update(long value) {
        this.valuePerBucket.update(value);
    }

    @Override
    public Snapshot getSnapshot() {
        long startTime = this.getNormalizedStartTime(this.clock.getTime());
        Map<Long, Long> valueResult = this.valuePerBucket.getBucketCounts(startTime);
        long value = 0L;
        if (!valueResult.isEmpty()) {
            value = valueResult.entrySet().iterator().next().getValue();
        }
        Map<Long, Long> countResult = this.countPerBucket.getBucketCounts(startTime);
        long count = 0L;
        if (!countResult.isEmpty()) {
            count = countResult.entrySet().iterator().next().getValue();
        }
        return new BucketSnapshot(count, value);
    }

    private long getNormalizedStartTime(long current) {
        return (TimeUnit.MILLISECONDS.toSeconds(current) - (long)this.interval) / (long)this.interval * (long)this.interval * 1000L;
    }
}

