/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Bucket;
import java.util.ArrayList;
import java.util.List;

class BucketDeque {
    private final Bucket[] queue;
    private int current = 0;

    BucketDeque(int length) {
        this.queue = new Bucket[length];
        for (int i = 0; i < length; ++i) {
            this.queue[i] = new Bucket();
        }
    }

    void addLast(Bucket e) {
        this.current = (this.current + 1) % this.queue.length;
        this.queue[this.current] = e;
    }

    Bucket peek() {
        return this.queue[this.current];
    }

    List<Bucket> getBucketList() {
        int i;
        int length = this.queue.length - 1;
        ArrayList<Bucket> bucketList = new ArrayList<Bucket>();
        int startPos = this.current;
        long startTs = this.queue[this.current].timestamp;
        if (startPos < 0) {
            startPos = 0;
        }
        for (i = startPos; i >= 0 && startPos - i < length; --i) {
            bucketList.add(this.queue[i]);
        }
        for (i = length; i > startPos + 1; --i) {
            if (this.queue[i].timestamp > startTs) continue;
            bucketList.add(this.queue[i]);
        }
        return bucketList;
    }
}

