/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.metrics;

import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Bucket;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.BucketCounter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.BucketDeque;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Clock;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.Counter;
import com.alibaba.csp.ahas.shaded.com.alibaba.metrics.CounterImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class BucketCounterImpl
implements BucketCounter {
    private final Counter totalCount = new CounterImpl();
    private final AtomicReference<Bucket> latestBucket;
    private final BucketDeque buckets;
    private final Clock clock;
    private final boolean updateTotalCount;
    private int interval;
    private long initTimestamp;

    public BucketCounterImpl(int interval, boolean updateTotalCount) {
        this(interval, 10, Clock.defaultClock(), updateTotalCount);
    }

    public BucketCounterImpl(int interval) {
        this(interval, 10, Clock.defaultClock(), true);
    }

    public BucketCounterImpl(int interval, int numberOfBucket, Clock clock) {
        this(interval, numberOfBucket, clock, true);
    }

    public BucketCounterImpl(int interval, int numberOfBucket, Clock clock, boolean updateTotalCount) {
        this.interval = interval;
        this.buckets = new BucketDeque(numberOfBucket + 1);
        this.clock = clock;
        this.latestBucket = new AtomicReference<Bucket>(this.buckets.peek());
        this.updateTotalCount = updateTotalCount;
        this.initTimestamp = clock.getTime();
    }

    @Override
    public void update() {
        this.update(1L);
    }

    @Override
    public void update(long n) {
        if (this.updateTotalCount) {
            this.totalCount.inc(n);
        }
        long curTs = TimeUnit.MILLISECONDS.toSeconds(this.clock.getTime()) / (long)this.interval * (long)this.interval;
        Bucket oldBucket = this.latestBucket.get();
        if (curTs > this.latestBucket.get().timestamp) {
            Bucket newBucket = new Bucket();
            newBucket.timestamp = curTs;
            if (this.latestBucket.compareAndSet(oldBucket, newBucket)) {
                this.buckets.addLast(newBucket);
                oldBucket = newBucket;
            } else {
                oldBucket = this.latestBucket.get();
            }
        }
        oldBucket.count.add(n);
    }

    @Override
    public Map<Long, Long> getBucketCounts(long startTime) {
        LinkedHashMap<Long, Long> counts = new LinkedHashMap<Long, Long>();
        long curTs = this.calculateCurrentTimestamp(this.clock.getTime());
        for (Bucket bucket : this.buckets.getBucketList()) {
            if (1000L * bucket.timestamp < startTime || bucket.timestamp > curTs) continue;
            counts.put(1000L * bucket.timestamp, bucket.count.sum());
        }
        return counts;
    }

    @Override
    public Map<Long, Long> getBucketCounts() {
        return this.getBucketCounts(0L);
    }

    @Override
    public int getBucketInterval() {
        return this.interval;
    }

    @Override
    public void inc() {
        this.update();
    }

    @Override
    public void inc(long n) {
        this.update(n);
    }

    @Override
    public void dec() {
        this.update(-1L);
    }

    @Override
    public void dec(long n) {
        this.update(-n);
    }

    @Override
    public long getCount() {
        return this.totalCount.getCount();
    }

    @Override
    public long lastUpdateTime() {
        long ts = this.latestBucket.get().timestamp;
        if (ts < 0L) {
            return this.initTimestamp;
        }
        return TimeUnit.SECONDS.toMillis(ts);
    }

    private long calculateCurrentTimestamp(long timestamp) {
        return TimeUnit.MILLISECONDS.toSeconds(timestamp) / (long)this.interval * (long)this.interval;
    }
}

