/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.edas.acm.filter;

import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.DefaultAcsClient;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.auth.BasicSessionCredentials;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.auth.InstanceProfileCredentialsProvider;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.auth.StaticCredentialsProvider;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.exceptions.ClientException;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.http.FormatType;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.http.MethodType;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.http.ProtocolType;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.kms.model.v20160120.DecryptRequest;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.kms.model.v20160120.EncryptRequest;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.kms.model.v20160120.GenerateDataKeyRequest;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.kms.model.v20160120.GenerateDataKeyResponse;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.profile.DefaultProfile;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.profile.IClientProfile;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.org.json.JSONObject;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.org.json.JSONTokener;
import com.alibaba.csp.ahas.shaded.com.alibaba.edas.acm.filter.IACMConfigFilter;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.exception.DiamondException;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.manager.IConfigFilterChain;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.manager.IConfigRequest;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.manager.IConfigResponse;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.manager.IFilterConfig;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.manager.impl.ConfigRequest;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.manager.impl.ConfigResponse;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.utils.AESUtils;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.utils.StringUtils;

public class KMSConfigFilter
implements IACMConfigFilter {
    private DefaultAcsClient kmsClient;
    private String keyId;
    private int order = 100;

    @Override
    public void doFilter(IConfigRequest request, IConfigResponse response, IConfigFilterChain filterChain) throws DiamondException {
        String dataId = null;
        String group = null;
        try {
            ConfigRequest requestTmp = (ConfigRequest)request;
            ConfigResponse responseTmp = (ConfigResponse)response;
            if (request != null && requestTmp.getDataId().startsWith("cipher-")) {
                dataId = requestTmp.getDataId();
                group = requestTmp.getGroup();
                if (requestTmp.getContent() != null) {
                    requestTmp.setContent(this.encrypt(this.keyId, requestTmp));
                }
            }
            filterChain.doFilter(requestTmp, responseTmp);
            if (responseTmp != null && responseTmp.getDataId().startsWith("cipher-")) {
                dataId = responseTmp.getDataId();
                group = responseTmp.getGroup();
                if (responseTmp.getContent() != null) {
                    responseTmp.setContent(this.decrypt(responseTmp));
                }
            }
        }
        catch (ClientException e) {
            String message = String.format("KMS error, dataId: %s, groupId: %s", dataId, group);
            throw new DiamondException(500, message, e);
        }
        catch (Exception e) {
            throw new DiamondException(e);
        }
    }

    private DefaultAcsClient kmsClient(String regionId, String accessKeyId, String accessKeySecret) {
        DefaultProfile profile = DefaultProfile.getProfile(regionId, accessKeyId, accessKeySecret);
        return new DefaultAcsClient(profile);
    }

    private DefaultAcsClient kmsClient(String regionId, String ramRoleName) {
        DefaultProfile profile = DefaultProfile.getProfile(regionId);
        InstanceProfileCredentialsProvider alibabaCloudCredentialsProvider = new InstanceProfileCredentialsProvider(ramRoleName);
        return new DefaultAcsClient((IClientProfile)profile, alibabaCloudCredentialsProvider);
    }

    private String decrypt(ConfigResponse configResponse) throws Exception {
        String encryptedDataKey;
        String dataId = configResponse.getDataId();
        if (dataId.startsWith("cipher-kms-aes-128-") && !StringUtils.isBlank(encryptedDataKey = configResponse.getEncryptedDataKey())) {
            String dataKey = this.decrypt(encryptedDataKey);
            return AESUtils.decrypt(configResponse.getContent(), dataKey, "UTF-8");
        }
        return this.decrypt(configResponse.getContent());
    }

    private String decrypt(String content) throws ClientException {
        DecryptRequest decReq = new DecryptRequest();
        decReq.setProtocol(ProtocolType.HTTPS);
        decReq.setAcceptFormat(FormatType.JSON);
        decReq.setMethod(MethodType.POST);
        decReq.setCiphertextBlob(content);
        return this.kmsClient.getAcsResponse(decReq).getPlaintext();
    }

    private String encrypt(String keyId, ConfigRequest configRequest) throws Exception {
        String dataId = configRequest.getDataId();
        if (dataId.startsWith("cipher-kms-aes-128-")) {
            GenerateDataKeyResponse generateDataKeyResponse = this.generateDataKey(keyId, "AES_128");
            configRequest.setEncryptedDataKey(generateDataKeyResponse.getCiphertextBlob());
            String dataKey = generateDataKeyResponse.getPlaintext();
            return AESUtils.encrypt(configRequest.getContent(), dataKey, "UTF-8");
        }
        return this.encrypt(keyId, configRequest.getContent());
    }

    private GenerateDataKeyResponse generateDataKey(String keyId, String keySpec) throws ClientException {
        GenerateDataKeyRequest generateDataKeyRequest = new GenerateDataKeyRequest();
        generateDataKeyRequest.setProtocol(ProtocolType.HTTPS);
        generateDataKeyRequest.setAcceptFormat(FormatType.JSON);
        generateDataKeyRequest.setMethod(MethodType.POST);
        generateDataKeyRequest.setKeyId(keyId);
        generateDataKeyRequest.setKeySpec(keySpec);
        return this.kmsClient.getAcsResponse(generateDataKeyRequest);
    }

    private String encrypt(String keyId, String plainText) throws ClientException {
        EncryptRequest encReq = new EncryptRequest();
        encReq.setProtocol(ProtocolType.HTTPS);
        encReq.setAcceptFormat(FormatType.JSON);
        encReq.setMethod(MethodType.POST);
        encReq.setKeyId(keyId);
        encReq.setPlaintext(plainText);
        return this.kmsClient.getAcsResponse(encReq).getCiphertextBlob();
    }

    @Override
    public void init(IFilterConfig filterConfig) {
        this.keyId = (String)filterConfig.getInitParameter("keyId");
        String regionId = (String)filterConfig.getInitParameter("regionId");
        String ramRoleName = (String)filterConfig.getInitParameter("ramRoleName");
        String securityCredentials = (String)filterConfig.getInitParameter("securityCredentials");
        if (!StringUtils.isBlank(securityCredentials)) {
            this.initKMSClientBySecurityCredentials(regionId, securityCredentials);
        } else if (!StringUtils.isBlank(ramRoleName)) {
            this.kmsClient = this.kmsClient(regionId, ramRoleName);
        } else {
            String accessKey = (String)filterConfig.getInitParameter("accessKey");
            String secretKey = (String)filterConfig.getInitParameter("secretKey");
            this.kmsClient = this.kmsClient(regionId, accessKey, secretKey);
        }
        Object orderObject = filterConfig.getInitParameter("order");
        if (orderObject != null) {
            this.order = (Integer)orderObject;
        }
    }

    private void initKMSClientBySecurityCredentials(String regionId, String securityCredentials) {
        JSONTokener jsonTokener = new JSONTokener(securityCredentials);
        JSONObject jsonObject = new JSONObject(jsonTokener);
        String accessKeyId = jsonObject.getString("AccessKeyId");
        String accessKeySecret = jsonObject.getString("AccessKeySecret");
        String securityToken = jsonObject.getString("SecurityToken");
        DefaultProfile profile = DefaultProfile.getProfile(regionId);
        BasicSessionCredentials cloudCredentials = new BasicSessionCredentials(accessKeyId, accessKeySecret, securityToken);
        StaticCredentialsProvider alibabaCloudCredentialsProvider = new StaticCredentialsProvider(cloudCredentials);
        this.kmsClient = new DefaultAcsClient((IClientProfile)profile, alibabaCloudCredentialsProvider);
    }

    @Override
    public void deploy() {
        this.kmsClient = null;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public String getFilterName() {
        return this.getClass().getName();
    }
}

