/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.csp.sentinel.datasource.acm;

import com.alibaba.csp.ahas.shaded.com.alibaba.edas.acm.ConfigService;
import com.alibaba.csp.ahas.shaded.com.alibaba.edas.acm.listener.ConfigChangeListener;
import com.alibaba.csp.sentinel.datasource.AbstractDataSource;
import com.alibaba.csp.sentinel.datasource.Converter;
import com.alibaba.csp.sentinel.log.RecordLog;

public class AcmDataSource<T>
extends AbstractDataSource<String, T> {
    private String dataId;
    private String group;
    private ConfigChangeListener listener;

    public AcmDataSource(String dataId, String group, Converter<String, T> parser) {
        super(parser);
        this.dataId = dataId;
        this.group = group;
        try {
            Object value = this.loadConfig();
            this.getProperty().updateValue(value);
        }
        catch (Exception e) {
            RecordLog.info(e.getMessage(), e);
        }
        this.listener = new ConfigChangeListener(){

            @Override
            public void receiveConfigInfo(String conf) {
                try {
                    RecordLog.info("receive conf ->" + conf, new Object[0]);
                    Object newValue = AcmDataSource.this.loadConfig(conf);
                    AcmDataSource.this.getProperty().updateValue(newValue);
                }
                catch (Exception e) {
                    RecordLog.info(e.getMessage(), e);
                }
            }
        };
        ConfigService.addListener(dataId, group, this.listener);
    }

    @Override
    public String readSource() throws Exception {
        String conf = ConfigService.getConfig(this.dataId, this.group, 5000L);
        RecordLog.info("read conf ->" + conf, new Object[0]);
        return conf;
    }

    @Override
    public void close() {
    }
}

