/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.org.codehaus.jackson.map.deser.std;

import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.org.codehaus.jackson.JsonParser;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.org.codehaus.jackson.JsonProcessingException;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.org.codehaus.jackson.JsonToken;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.org.codehaus.jackson.map.DeserializationContext;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.org.codehaus.jackson.map.annotate.JacksonStdImpl;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.org.codehaus.jackson.map.deser.std.StdScalarDeserializer;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JacksonStdImpl
public class ClassDeserializer
extends StdScalarDeserializer<Class<?>> {
    public ClassDeserializer() {
        super(Class.class);
    }

    @Override
    public Class<?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken curr = jp.getCurrentToken();
        if (curr == JsonToken.VALUE_STRING) {
            String className = jp.getText();
            if (className.indexOf(46) < 0) {
                if ("int".equals(className)) {
                    return Integer.TYPE;
                }
                if ("long".equals(className)) {
                    return Long.TYPE;
                }
                if ("float".equals(className)) {
                    return Float.TYPE;
                }
                if ("double".equals(className)) {
                    return Double.TYPE;
                }
                if ("boolean".equals(className)) {
                    return Boolean.TYPE;
                }
                if ("byte".equals(className)) {
                    return Byte.TYPE;
                }
                if ("char".equals(className)) {
                    return Character.TYPE;
                }
                if ("short".equals(className)) {
                    return Short.TYPE;
                }
                if ("void".equals(className)) {
                    return Void.TYPE;
                }
            }
            try {
                return Class.forName(jp.getText());
            }
            catch (ClassNotFoundException e) {
                throw ctxt.instantiationException(this._valueClass, e);
            }
        }
        throw ctxt.mappingException(this._valueClass, curr);
    }
}

