/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.utils;

import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.utils.IOUtils;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Collection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class HttpsUtils {
    public static SSLSocketFactory buildJavaSSLSocketFactory(String certPath) throws SSLException {
        String trustCertPath = certPath != null ? certPath : HttpsUtils.getTrustCertPath();
        String truststoreFile = HttpsUtils.getTruststoreFile();
        if (trustCertPath == null && truststoreFile == null) {
            return null;
        }
        try {
            String secureSocketProtocol = HttpsUtils.getSecureSocketProtocol();
            SSLContext sc = SSLContext.getInstance(secureSocketProtocol);
            TrustManager[] trustManagers = null;
            if (trustCertPath != null) {
                trustManagers = HttpsUtils.buildCertTrustManager(trustCertPath);
            } else if (truststoreFile != null) {
                trustManagers = HttpsUtils.buildTrustStoreTrustManager();
            }
            sc.init(null, trustManagers, new SecureRandom());
            return sc.getSocketFactory();
        }
        catch (Exception e) {
            throw new SSLException("Https buildSSLSocketFactory error ", e);
        }
    }

    private static TrustManager[] buildTrustStoreTrustManager() throws SSLException {
        try {
            String truststoreType = HttpsUtils.getTruststoreType();
            String truststoreFile = HttpsUtils.getTruststoreFile();
            String truststorePassword = HttpsUtils.getTruststorePassword();
            String truststoreAlgorithm = HttpsUtils.getTruststoreAlgorithm();
            KeyStore keyStore = KeyStore.getInstance(truststoreType);
            keyStore.load(new FileInputStream(truststoreFile), truststorePassword.toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(truststoreAlgorithm);
            tmf.init(keyStore);
            return tmf.getTrustManagers();
        }
        catch (Exception ex) {
            throw new SSLException(ex);
        }
    }

    private static TrustManager[] buildCertTrustManager(String trustCertPath) throws SSLException {
        TrustManager[] trustManagerArray;
        FileInputStream in = null;
        try {
            TrustManager[] trustManagerArray2;
            String algorithm = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory selfTmf = TrustManagerFactory.getInstance(algorithm);
            KeyStore trustKeyStore = KeyStore.getInstance("JKS");
            trustKeyStore.load(null, null);
            in = new FileInputStream(trustCertPath);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> certs = cf.generateCertificates(in);
            int count = 0;
            for (Certificate certificate : certs) {
                trustKeyStore.setCertificateEntry("cert-" + count++, certificate);
            }
            selfTmf.init(trustKeyStore);
            trustManagerArray = trustManagerArray2 = selfTmf.getTrustManagers();
        }
        catch (Exception ex) {
            try {
                throw new SSLException(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(in);
        return trustManagerArray;
    }

    private static String getTrustCertPath() {
        return System.getProperty("aliyun.sdk.ssl.trustCertPath");
    }

    private static String getTruststoreFile() {
        return System.getProperty("aliyun.sdk.ssl.truststoreFile");
    }

    private static String getSecureSocketProtocol() {
        return System.getProperty("aliyun.sdk.ssl.secureSocketProtocol", "TLSv1.2");
    }

    private static String getTruststoreType() {
        return System.getProperty("aliyun.sdk.ssl.truststoreType", "JKS");
    }

    private static String getTruststorePassword() {
        return System.getProperty("aliyun.sdk.ssl.truststorePassword", null);
    }

    private static String getTruststoreAlgorithm() {
        return System.getProperty("aliyun.sdk.ssl.truststoreAlgorithm", "SunX509");
    }
}

