/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.endpoint;

import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.endpoint.LocalConfigRegionalEndpointResolver;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.endpoint.ResolveEndpointRequest;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.google.gson.JsonObject;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.google.gson.JsonParser;

public class LocalConfigGlobalEndpointResolver
extends LocalConfigRegionalEndpointResolver {
    public LocalConfigGlobalEndpointResolver() {
        JsonObject obj = this.readLocalConfigAsJsonObject();
        this.initLocalConfig(obj);
    }

    public LocalConfigGlobalEndpointResolver(String configJsonStr) {
        JsonObject obj = new JsonParser().parse(configJsonStr).getAsJsonObject();
        this.initLocalConfig(obj);
    }

    protected void initLocalConfig(JsonObject obj) {
        this.initGlobalEndpointData(obj);
        this.initRegionIds(obj);
    }

    private void initGlobalEndpointData(JsonObject obj) {
        if (!obj.has("global_endpoints")) {
            return;
        }
        JsonObject globalEndpoints = obj.get("global_endpoints").getAsJsonObject();
        for (String locationServiceCode : globalEndpoints.keySet()) {
            String endpoint = globalEndpoints.get(locationServiceCode).getAsString();
            this.putEndpointEntry(this.makeEndpointKey(locationServiceCode), endpoint);
        }
    }

    @Override
    public String resolve(ResolveEndpointRequest request) {
        if (request.isOpenApiEndpoint() && this.isRegionIdValid(request.regionId)) {
            return this.fetchEndpointEntry(request);
        }
        return null;
    }

    @Override
    public String makeEndpointKey(ResolveEndpointRequest request) {
        return this.makeEndpointKey(request.productCodeLower);
    }

    public String makeEndpointKey(String productCodeLower) {
        return this.getNormalizedProductCode(productCodeLower);
    }
}

