/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.auth;

import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.DefaultAcsClient;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.IAcsClient;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.auth.AlibabaCloudCredentials;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.auth.AlibabaCloudCredentialsProvider;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.auth.BasicSessionCredentials;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.auth.StaticCredentialsProvider;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.auth.sts.AssumeRoleRequest;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.auth.sts.AssumeRoleResponse;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.exceptions.ClientException;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.exceptions.ServerException;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.profile.IClientProfile;

public class STSAssumeRoleSessionCredentialsProvider
implements AlibabaCloudCredentialsProvider {
    public static final int DEFAULT_DURATION_SECONDS = 3600;
    private IAcsClient stsClient;
    private final String roleArn;
    private String roleSessionName;
    private long roleSessionDurationSeconds;
    private BasicSessionCredentials credentials = null;
    public long assumeRoleRound = 0L;

    public STSAssumeRoleSessionCredentialsProvider(AlibabaCloudCredentials longLivedCredentials, String roleArn, IClientProfile clientProfile) {
        this(new StaticCredentialsProvider(longLivedCredentials), roleArn, clientProfile);
    }

    public STSAssumeRoleSessionCredentialsProvider withRoleSessionName(String roleSessionName) {
        this.roleSessionName = roleSessionName;
        return this;
    }

    public STSAssumeRoleSessionCredentialsProvider withRoleSessionDurationSeconds(long roleSessionDurationSeconds) {
        if (roleSessionDurationSeconds < 900L || roleSessionDurationSeconds > 3600L) {
            throw new IllegalArgumentException("Assume Role session duration should be in the range of 15min - 1Hr");
        }
        this.roleSessionDurationSeconds = roleSessionDurationSeconds;
        return this;
    }

    public STSAssumeRoleSessionCredentialsProvider withSTSClient(IAcsClient client) {
        this.stsClient = client;
        return this;
    }

    public STSAssumeRoleSessionCredentialsProvider(AlibabaCloudCredentialsProvider longLivedCredentialsProvider, String roleArn, IClientProfile clientProfile) {
        if (roleArn == null) {
            throw new NullPointerException("You must specify a value for roleArn.");
        }
        this.roleArn = roleArn;
        this.roleSessionName = STSAssumeRoleSessionCredentialsProvider.getNewRoleSessionName();
        this.stsClient = new DefaultAcsClient(clientProfile, longLivedCredentialsProvider);
        this.roleSessionDurationSeconds = 3600L;
    }

    public static String getNewRoleSessionName() {
        return "aliyun-java-sdk-" + System.currentTimeMillis();
    }

    @Override
    public AlibabaCloudCredentials getCredentials() throws ClientException, ServerException {
        if (this.credentials == null || this.credentials.willSoonExpire()) {
            this.credentials = this.getNewSessionCredentials();
        }
        return this.credentials;
    }

    private BasicSessionCredentials getNewSessionCredentials() throws ClientException, ServerException {
        ++this.assumeRoleRound;
        AssumeRoleRequest assumeRoleRequest = new AssumeRoleRequest();
        assumeRoleRequest.setRoleArn(this.roleArn);
        assumeRoleRequest.setRoleSessionName(this.roleSessionName);
        assumeRoleRequest.setDurationSeconds(this.roleSessionDurationSeconds);
        AssumeRoleResponse response = this.stsClient.getAcsResponse(assumeRoleRequest);
        return new BasicSessionCredentials(response.getCredentials().getAccessKeyId(), response.getCredentials().getAccessKeySecret(), response.getCredentials().getSecurityToken(), this.roleSessionDurationSeconds);
    }
}

