/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs;

import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.AcsRequest;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.CommonRoaRequest;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.CommonRpcRequest;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.http.FormatType;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.http.MethodType;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.http.ProtocolType;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.aliyuncs.regions.ProductDomain;
import java.util.HashMap;
import java.util.Map;

public class CommonRequest {
    private String version = null;
    private String product = null;
    private String action = null;
    private String locationProduct = null;
    private String endpointType = null;
    private String regionId = null;
    private ProtocolType protocol = null;
    private final Map<String, String> queryParameters = new HashMap<String, String>();
    private final Map<String, String> bodyParameters = new HashMap<String, String>();
    private final Map<String, String> headParameters = new HashMap<String, String>();
    private Integer connectTimeout = null;
    private Integer readTimeout = null;
    private MethodType method = null;
    private FormatType httpContentType = null;
    private byte[] httpContent = null;
    private String encoding = null;
    private String uriPattern = null;
    private Map<String, String> pathParameters = new HashMap<String, String>();
    private String domain = null;

    public AcsRequest buildRequest() {
        if (this.uriPattern != null) {
            CommonRoaRequest request = new CommonRoaRequest(this.product);
            request.setUriPattern(this.uriPattern);
            for (String pathParamKey : this.pathParameters.keySet()) {
                request.putPathParameter(pathParamKey, this.pathParameters.get(pathParamKey));
            }
            this.fillParams(request);
            return request;
        }
        CommonRpcRequest request = new CommonRpcRequest(this.product);
        this.fillParams(request);
        return request;
    }

    private void fillParams(AcsRequest request) {
        request.putHeaderParameter("x-sdk-invoke-type", "common");
        if (this.version != null) {
            request.setVersion(this.version);
        }
        if (this.action != null) {
            request.setActionName(this.action);
        }
        if (this.regionId != null) {
            request.setRegionId(this.regionId);
        }
        if (this.locationProduct != null) {
            request.setLocationProduct(this.locationProduct);
        }
        if (this.endpointType != null) {
            request.setEndpointType(this.endpointType);
        }
        if (this.connectTimeout != null) {
            request.setConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout != null) {
            request.setReadTimeout(this.readTimeout);
        }
        if (this.method != null) {
            request.setMethod(this.method);
        }
        if (this.protocol != null) {
            request.setProtocol(this.protocol);
        }
        if (this.domain != null) {
            ProductDomain productDomain = new ProductDomain(this.product, this.domain);
            request.setProductDomain(productDomain);
        }
        if (this.httpContent != null) {
            request.setHttpContent(this.httpContent, this.encoding, this.httpContentType);
        }
        for (String queryParamKey : this.queryParameters.keySet()) {
            request.putQueryParameter(queryParamKey, this.queryParameters.get(queryParamKey));
        }
        for (String bodyParamKey : this.bodyParameters.keySet()) {
            request.putBodyParameter(bodyParamKey, this.bodyParameters.get(bodyParamKey));
        }
        for (String headParamKey : this.headParameters.keySet()) {
            request.putHeaderParameter(headParamKey, this.headParameters.get(headParamKey));
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getLocationProduct() {
        return this.locationProduct;
    }

    public void setLocationProduct(String locationProduct) {
        this.locationProduct = locationProduct;
    }

    public String getEndpointType() {
        return this.endpointType;
    }

    public void setEndpointType(String endpointType) {
        this.endpointType = endpointType;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public ProtocolType getProtocol() {
        return this.protocol;
    }

    public void setProtocol(ProtocolType protocol) {
        this.protocol = protocol;
    }

    public void putBodyParameter(String name, Object value) {
        this.setParameter(this.bodyParameters, name, value);
    }

    public void putQueryParameter(String name, String value) {
        this.setParameter(this.queryParameters, name, value);
    }

    public void putHeadParameter(String name, String value) {
        this.setParameter(this.headParameters, name, value);
    }

    private void setParameter(Map<String, String> map, String name, Object value) {
        if (null == map || null == name || null == value) {
            return;
        }
        map.put(name, String.valueOf(value));
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public MethodType getMethod() {
        return this.method;
    }

    public void setMethod(MethodType method) {
        this.method = method;
    }

    public String getUriPattern() {
        return this.uriPattern;
    }

    public void setUriPattern(String uriPattern) {
        this.uriPattern = uriPattern;
    }

    public void putPathParameter(String name, String value) {
        this.setParameter(this.pathParameters, name, value);
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setHttpContent(byte[] content, String encoding, FormatType format) {
        if (content == null || encoding == null || format == null) {
            return;
        }
        this.httpContent = content;
        this.httpContentType = format;
        this.encoding = encoding;
    }
}

